/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mybatis.runtime;

import io.quarkiverse.mybatis.runtime.ConfigurationFactory;
import io.quarkiverse.mybatis.runtime.QuarkusDataSource;
import io.quarkiverse.mybatis.runtime.QuarkusDataSourceFactory;
import io.quarkiverse.mybatis.runtime.TransactionalSqlSession;
import io.quarkiverse.mybatis.runtime.XMLConfigDelegateBuilder;
import io.quarkiverse.mybatis.runtime.config.MyBatisDataSourceRuntimeConfig;
import io.quarkiverse.mybatis.runtime.config.MyBatisRuntimeConfig;
import io.quarkiverse.mybatis.runtime.meta.MapperDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.transaction.TransactionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.executor.loader.ProxyFactory;
import org.apache.ibatis.executor.loader.cglib.CglibProxyFactory;
import org.apache.ibatis.executor.loader.javassist.JavassistProxyFactory;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;

@Recorder
public class MyBatisRecorder {
    private static final Logger LOG = Logger.getLogger(MyBatisRecorder.class);

    public RuntimeValue<SqlSessionFactory> createSqlSessionFactory(MyBatisRuntimeConfig config, XMLConfigDelegateBuilder builder) {
        Configuration configuration;
        try {
            builder.setConfig(config);
            builder.getConfiguration().getTypeAliasRegistry().registerAlias("QUARKUS", QuarkusDataSourceFactory.class);
            configuration = builder.parse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        return new RuntimeValue((Object)sqlSessionFactory);
    }

    public RuntimeValue<SqlSessionFactory> createSqlSessionFactory(ConfigurationFactory configurationFactory, List<Consumer<Configuration>> customizers, SqlSessionFactoryBuilder builder, MyBatisRuntimeConfig myBatisRuntimeConfig, MyBatisDataSourceRuntimeConfig myBatisDataSourceRuntimeConfig, String dataSourceName, List<String> mappers, List<String> mappedTypes, List<String> mappedJdbcTypes) {
        Configuration configuration = configurationFactory.createConfiguration();
        customizers.forEach(customizer -> customizer.accept(configuration));
        this.setupConfiguration(configuration, configurationFactory.isOverrideSetting(), myBatisRuntimeConfig, myBatisDataSourceRuntimeConfig, dataSourceName);
        this.addMappers(configuration, myBatisRuntimeConfig, mappedTypes, mappedJdbcTypes, mappers, dataSourceName);
        SqlSessionFactory sqlSessionFactory = builder.build(configuration);
        return new RuntimeValue((Object)sqlSessionFactory);
    }

    private void buildFromMapperLocations(Configuration configuration, MyBatisRuntimeConfig myBatisRuntimeConfig, String dataSourceName) {
        myBatisRuntimeConfig.mapperLocations.ifPresent(mapperLocations -> {
            for (String mapperLocation : mapperLocations) {
                try {
                    File[] files;
                    URL resource;
                    if (mapperLocation.endsWith("/")) {
                        mapperLocation = mapperLocation.substring(0, mapperLocation.length() - 1);
                    }
                    if (mapperLocation.startsWith("/")) {
                        mapperLocation = mapperLocation.substring(1);
                    }
                    if ((resource = Thread.currentThread().getContextClassLoader().getResource(mapperLocation)) == null) continue;
                    String path = resource.getFile();
                    if (path != null && path.contains("jar!")) {
                        File resourceFile = Paths.get(new URL(path.substring(0, path.indexOf("!"))).toURI()).toFile();
                        JarFile jarFile = new JarFile(resourceFile);
                        try {
                            Enumeration<JarEntry> entries = jarFile.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry entry = entries.nextElement();
                                String resourceName = entry.getName();
                                if (entry.isDirectory() || !resourceName.startsWith(mapperLocation) || resourceName.endsWith(".class") || !resourceName.endsWith(".xml")) continue;
                                this.buildXmlMapper(jarFile.getInputStream(entry), jarFile.getInputStream(entry), entry.toString(), configuration, dataSourceName);
                            }
                            continue;
                        }
                        finally {
                            jarFile.close();
                            continue;
                        }
                    }
                    if (path == null || (files = new File(path).listFiles()) == null) continue;
                    for (File file : files) {
                        if (!file.getName().endsWith(".xml")) continue;
                        this.buildXmlMapper(new FileInputStream(file), new FileInputStream(file), file.toString(), configuration, dataSourceName);
                    }
                }
                catch (IOException | NullPointerException | URISyntaxException e) {
                    LOG.warnf("Not found mapper location :%s.", (Object)mapperLocation);
                }
                catch (ClassNotFoundException e) {
                    LOG.warnf("Not found mapper class :%s.", (Object)e.getMessage());
                }
            }
        });
    }

    private void buildXmlMapper(InputStream filterStream, InputStream resourceStream, String resource, Configuration configuration, String dataSourceName) throws ClassNotFoundException {
        XPathParser xPathParser = new XPathParser(filterStream, true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
        String nameSpace = xPathParser.evalNode("/mapper").getStringAttribute("namespace");
        Class mapperClass = Resources.classForName((String)nameSpace);
        MapperDataSource annotation = mapperClass.getAnnotation(MapperDataSource.class);
        if (annotation != null && annotation.value().equals(dataSourceName) || annotation == null && dataSourceName.equals("<default>")) {
            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resourceStream, configuration, resource, configuration.getSqlFragments());
            xmlMapperBuilder.parse();
        }
    }

    private void addMappers(Configuration configuration, MyBatisRuntimeConfig myBatisRuntimeConfig, List<String> mappedTypes, List<String> mappedJdbcTypes, List<String> mappers, String dataSourceName) {
        for (String mappedType : mappedTypes) {
            try {
                configuration.getTypeHandlerRegistry().register(Resources.classForName((String)mappedType));
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)("Can not find the mapped type class " + mappedType));
            }
        }
        for (String mappedJdbcType : mappedJdbcTypes) {
            try {
                configuration.getTypeHandlerRegistry().register(Resources.classForName((String)mappedJdbcType));
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)("Can not find the mapped jdbc type class " + mappedJdbcType));
            }
        }
        this.buildFromMapperLocations(configuration, myBatisRuntimeConfig, dataSourceName);
        for (String mapper : mappers) {
            try {
                if (configuration.getMapperRegistry().hasMapper(Resources.classForName((String)mapper))) continue;
                configuration.addMapper(Resources.classForName((String)mapper));
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)("Can not find the mapper class " + mapper));
            }
        }
    }

    private void setupConfiguration(Configuration configuration, boolean isOverrideSetting, MyBatisRuntimeConfig runtimeConfig, MyBatisDataSourceRuntimeConfig dataSourceRuntimeConfig, String dataSourceName) {
        String proxyFactory;
        String transactionFactory = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.transactionFactory.isPresent() ? dataSourceRuntimeConfig.transactionFactory.get() : runtimeConfig.transactionFactory;
        Object factory = transactionFactory.equals("MANAGED") ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        configuration.setCacheEnabled(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.cacheEnabled.isPresent() ? dataSourceRuntimeConfig.cacheEnabled.get() : runtimeConfig.cacheEnabled);
        configuration.setLazyLoadingEnabled(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.lazyLoadingEnabled.isPresent() ? dataSourceRuntimeConfig.lazyLoadingEnabled.get() : runtimeConfig.lazyLoadingEnabled);
        configuration.setAggressiveLazyLoading(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.aggressiveLazyLoading.isPresent() ? dataSourceRuntimeConfig.aggressiveLazyLoading.get() : runtimeConfig.aggressiveLazyLoading);
        configuration.setMultipleResultSetsEnabled(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.multipleResultSetsEnabled.isPresent() ? dataSourceRuntimeConfig.multipleResultSetsEnabled.get() : runtimeConfig.multipleResultSetsEnabled);
        configuration.setUseColumnLabel(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.useColumnLabel.isPresent() ? dataSourceRuntimeConfig.useColumnLabel.get() : runtimeConfig.useColumnLabel);
        configuration.setUseGeneratedKeys(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.useGeneratedKeys.isPresent() ? dataSourceRuntimeConfig.useGeneratedKeys.get() : runtimeConfig.useGeneratedKeys);
        configuration.setAutoMappingBehavior(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.autoMappingBehavior.isPresent() ? dataSourceRuntimeConfig.autoMappingBehavior.get() : runtimeConfig.autoMappingBehavior);
        configuration.setAutoMappingUnknownColumnBehavior(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.autoMappingUnknownColumnBehavior.isPresent() ? dataSourceRuntimeConfig.autoMappingUnknownColumnBehavior.get() : runtimeConfig.autoMappingUnknownColumnBehavior);
        configuration.setDefaultExecutorType(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.defaultExecutorType.isPresent() ? dataSourceRuntimeConfig.defaultExecutorType.get() : runtimeConfig.defaultExecutorType);
        if (dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.defaultStatementTimeout.isPresent()) {
            configuration.setDefaultStatementTimeout(dataSourceRuntimeConfig.defaultStatementTimeout.get());
        } else {
            runtimeConfig.defaultStatementTimeout.ifPresent(arg_0 -> ((Configuration)configuration).setDefaultStatementTimeout(arg_0));
        }
        if (dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.defaultFetchSize.isPresent()) {
            configuration.setDefaultFetchSize(dataSourceRuntimeConfig.defaultFetchSize.get());
        } else {
            runtimeConfig.defaultFetchSize.ifPresent(arg_0 -> ((Configuration)configuration).setDefaultFetchSize(arg_0));
        }
        if (dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.defaultResultSetType.isPresent()) {
            configuration.setDefaultResultSetType(dataSourceRuntimeConfig.defaultResultSetType.get());
        } else {
            runtimeConfig.defaultResultSetType.ifPresent(arg_0 -> ((Configuration)configuration).setDefaultResultSetType(arg_0));
        }
        configuration.setSafeRowBoundsEnabled(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.safeRowBoundsEnabled.isPresent() ? dataSourceRuntimeConfig.safeRowBoundsEnabled.get() : runtimeConfig.safeRowBoundsEnabled);
        configuration.setSafeResultHandlerEnabled(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.safeResultHandlerEnabled.isPresent() ? dataSourceRuntimeConfig.safeResultHandlerEnabled.get() : runtimeConfig.safeResultHandlerEnabled);
        configuration.setMapUnderscoreToCamelCase(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.mapUnderscoreToCamelCase.isPresent() ? dataSourceRuntimeConfig.mapUnderscoreToCamelCase.get() : runtimeConfig.mapUnderscoreToCamelCase);
        configuration.setLocalCacheScope(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.localCacheScope.isPresent() ? dataSourceRuntimeConfig.localCacheScope.get() : runtimeConfig.localCacheScope);
        configuration.setJdbcTypeForNull(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.jdbcTypeForNull.isPresent() ? dataSourceRuntimeConfig.jdbcTypeForNull.get() : runtimeConfig.jdbcTypeForNull);
        configuration.setLazyLoadTriggerMethods(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.lazyLoadTriggerMethods.isPresent() ? dataSourceRuntimeConfig.lazyLoadTriggerMethods.get() : runtimeConfig.lazyLoadTriggerMethods);
        try {
            if (!isOverrideSetting) {
                String defaultScriptingLanguage = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.defaultScriptingLanguage.isPresent() ? dataSourceRuntimeConfig.defaultScriptingLanguage.get() : runtimeConfig.defaultScriptingLanguage;
                configuration.setDefaultScriptingLanguage(Resources.classForName((String)defaultScriptingLanguage));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            if (!isOverrideSetting) {
                String defaultEnumTypeHandler = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.defaultEnumTypeHandler.isPresent() ? dataSourceRuntimeConfig.defaultEnumTypeHandler.get() : runtimeConfig.defaultEnumTypeHandler;
                configuration.setDefaultEnumTypeHandler(Resources.classForName((String)defaultEnumTypeHandler));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        configuration.setCallSettersOnNulls(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.callSettersOnNulls.isPresent() ? dataSourceRuntimeConfig.callSettersOnNulls.get() : runtimeConfig.callSettersOnNulls);
        configuration.setReturnInstanceForEmptyRow(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.returnInstanceForEmptyRow.isPresent() ? dataSourceRuntimeConfig.returnInstanceForEmptyRow.get() : runtimeConfig.returnInstanceForEmptyRow);
        if (dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.logPrefix.isPresent()) {
            configuration.setLogPrefix(dataSourceRuntimeConfig.logPrefix.get());
        } else {
            runtimeConfig.logPrefix.ifPresent(arg_0 -> ((Configuration)configuration).setLogPrefix(arg_0));
        }
        Optional<String> optionalLogImpl = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.logImpl.isPresent() ? dataSourceRuntimeConfig.logImpl : runtimeConfig.logImpl;
        optionalLogImpl.ifPresent(logImpl -> {
            try {
                configuration.setLogImpl(Resources.classForName((String)logImpl));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        String string = proxyFactory = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.proxyFactory.isPresent() ? dataSourceRuntimeConfig.proxyFactory.get() : runtimeConfig.proxyFactory;
        if ("JAVASSIST".equals(proxyFactory)) {
            configuration.setProxyFactory((ProxyFactory)new JavassistProxyFactory());
        } else if ("CGLIB".equals(proxyFactory)) {
            configuration.setProxyFactory((ProxyFactory)new CglibProxyFactory());
        }
        Optional<String> optionalVfsImpl = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.vfsImpl.isPresent() ? dataSourceRuntimeConfig.vfsImpl : runtimeConfig.vfsImpl;
        optionalVfsImpl.ifPresent(vfsImpl -> {
            try {
                configuration.setVfsImpl(Resources.classForName((String)vfsImpl));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        configuration.setUseActualParamName(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.useActualParamName.isPresent() ? dataSourceRuntimeConfig.useActualParamName.get() : runtimeConfig.useActualParamName);
        Optional<String> optionalConfigurationFactory = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.configurationFactory.isPresent() ? dataSourceRuntimeConfig.configurationFactory : runtimeConfig.configurationFactory;
        optionalConfigurationFactory.ifPresent(configurationFactory -> {
            try {
                configuration.setConfigurationFactory(Resources.classForName((String)configurationFactory));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        configuration.setShrinkWhitespacesInSql(dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.shrinkWhitespacesInSql.isPresent() ? dataSourceRuntimeConfig.shrinkWhitespacesInSql.get() : runtimeConfig.shrinkWhitespacesInSql);
        Optional<String> optionalDefaultSqlProviderType = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.defaultSqlProviderType.isPresent() ? dataSourceRuntimeConfig.defaultSqlProviderType : runtimeConfig.defaultSqlProviderType;
        optionalDefaultSqlProviderType.ifPresent(defaultSqlProviderType -> {
            try {
                configuration.setDefaultSqlProviderType(Resources.classForName((String)defaultSqlProviderType));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        String environment = dataSourceRuntimeConfig != null && dataSourceRuntimeConfig.environment.isPresent() ? dataSourceRuntimeConfig.environment.get() : runtimeConfig.environment;
        Environment.Builder environmentBuilder = new Environment.Builder(environment).transactionFactory((TransactionFactory)factory).dataSource((DataSource)new QuarkusDataSource(dataSourceName));
        configuration.setEnvironment(environmentBuilder.build());
    }

    public RuntimeValue<TransactionalSqlSession> createSqlSessionManager(RuntimeValue<SqlSessionFactory> sqlSessionFactory) {
        TransactionManager transactionManager = (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
        TransactionalSqlSession sqlSessionManager = new TransactionalSqlSession((SqlSessionFactory)sqlSessionFactory.getValue(), transactionManager);
        return new RuntimeValue((Object)sqlSessionManager);
    }

    public Supplier<Object> MyBatisMapperSupplier(String name, RuntimeValue<TransactionalSqlSession> sqlSessionManager) {
        return () -> {
            try {
                return ((TransactionalSqlSession)sqlSessionManager.getValue()).getMapper(Resources.classForName((String)name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        };
    }

    public Supplier<Object> MyBatisMappedTypeSupplier(String name, RuntimeValue<TransactionalSqlSession> sqlSessionManager) {
        return () -> {
            try {
                return ((TransactionalSqlSession)sqlSessionManager.getValue()).getConfiguration().getTypeHandlerRegistry().getTypeHandler(Resources.classForName((String)name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        };
    }

    public Supplier<Object> MyBatisMappedJdbcTypeSupplier(String name, RuntimeValue<TransactionalSqlSession> sqlSessionManager) {
        return () -> {
            try {
                return ((TransactionalSqlSession)sqlSessionManager.getValue()).getConfiguration().getTypeHandlerRegistry().getTypeHandler(Resources.classForName((String)name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        };
    }

    public Supplier<Object> MyBatisSqlSessionFactorySupplier(RuntimeValue<SqlSessionFactory> sqlSessionFactory) {
        return () -> sqlSessionFactory.getValue();
    }

    public void runInitialSql(RuntimeValue<SqlSessionFactory> sqlSessionFactory, String sql) {
        try (SqlSession session = ((SqlSessionFactory)sqlSessionFactory.getValue()).openSession();){
            Connection conn = session.getConnection();
            Reader reader = Resources.getResourceAsReader((String)sql);
            ScriptRunner runner = new ScriptRunner(conn);
            runner.setLogWriter(null);
            runner.runScript(reader);
            reader.close();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error executing SQL Script " + sql), (Throwable)e);
        }
    }
}

