/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mybatis.plus.runtime;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import io.quarkiverse.mybatis.plus.MyBatisPlusConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.jboss.logging.Logger;

@Recorder
public class MyBatisPlusRecorder {
    private static final Logger LOG = Logger.getLogger(MyBatisPlusRecorder.class);

    public void initSqlSession(RuntimeValue<SqlSessionFactory> sqlSessionFactory, MyBatisPlusConfig config) {
        Configuration configuration = ((SqlSessionFactory)sqlSessionFactory.getValue()).getConfiguration();
        if (config.pageEnabled) {
            MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
            interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
            configuration.addInterceptor((Interceptor)interceptor);
        }
        if (config.metaObjectHandler.isPresent()) {
            try {
                String classMetaObjectHandler = config.metaObjectHandler.get();
                MetaObjectHandler handler = (MetaObjectHandler)Resources.classForName((String)classMetaObjectHandler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String key = Integer.toHexString(configuration.hashCode());
                GlobalConfigUtils.getGlobalConfig((Configuration)configuration).setMetaObjectHandler(handler);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not initialize metaObjectHandler " + config.metaObjectHandler.get()));
            }
        }
    }
}

