/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mybatis.plus.deployment;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.MybatisSqlSessionFactoryBuilder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import io.quarkiverse.mybatis.deployment.ConfigurationFactoryBuildItem;
import io.quarkiverse.mybatis.deployment.SqlSessionFactoryBuilderBuildItem;
import io.quarkiverse.mybatis.deployment.XMLConfigBuilderBuildItem;
import io.quarkiverse.mybatis.plus.runtime.MyBatisPlusConfigurationFactory;
import io.quarkiverse.mybatis.plus.runtime.MyBatisPlusXMLConfigDelegateBuilder;
import io.quarkiverse.mybatis.runtime.ConfigurationFactory;
import io.quarkiverse.mybatis.runtime.XMLConfigDelegateBuilder;
import io.quarkiverse.mybatis.runtime.meta.MapperDataSource;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.ibatis.cache.decorators.LruCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class MyBatisPlusProcessor {
    private static final String FEATURE = "mybatis-plus";
    private static final DotName MYBATIS_PLUS_MAPPER = DotName.createSimple((String)BaseMapper.class.getName());
    private static final DotName MYBATIS_MAPPER_DATA_SOURCE = DotName.createSimple((String)MapperDataSource.class.getName());
    private static final DotName MYBATIS_PLUS_WRAPPER = DotName.createSimple((String)Wrapper.class.getName());
    private static final Logger LOG = Logger.getLogger(MyBatisPlusProcessor.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ConfigurationFactoryBuildItem createConfigurationFactory() {
        return new ConfigurationFactoryBuildItem((ConfigurationFactory)new MyBatisPlusConfigurationFactory());
    }

    @BuildStep
    SqlSessionFactoryBuilderBuildItem createSqlSessionFactoryBuilder() {
        return new SqlSessionFactoryBuilderBuildItem((SqlSessionFactoryBuilder)new MybatisSqlSessionFactoryBuilder());
    }

    @BuildStep
    XMLConfigBuilderBuildItem createXMLConfigBuilder() throws Exception {
        return new XMLConfigBuilderBuildItem((XMLConfigDelegateBuilder)new MyBatisPlusXMLConfigDelegateBuilder());
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.baomidou", "mybatis-plus-core"));
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem indexBuildItem) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{PerpetualCache.class, LruCache.class}));
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)TableName.class.getName()))) {
            if (i.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            DotName dotName = i.target().asClass().name();
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{dotName.toString()}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{MYBATIS_PLUS_WRAPPER.toString()}));
        for (ClassInfo classInfo : indexBuildItem.getIndex().getAllKnownSubclasses(MYBATIS_PLUS_WRAPPER)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{classInfo.name().toString()}));
        }
    }
}

