/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"Database", "DatabaseSize", "LatestVersion", "Memory", "Messages", "Version"})
public class AppInformation {
    public static final String JSON_PROPERTY_DATABASE = "Database";
    private String database;
    public static final String JSON_PROPERTY_DATABASE_SIZE = "DatabaseSize";
    private Long databaseSize;
    public static final String JSON_PROPERTY_LATEST_VERSION = "LatestVersion";
    private String latestVersion;
    public static final String JSON_PROPERTY_MEMORY = "Memory";
    private Integer memory;
    public static final String JSON_PROPERTY_MESSAGES = "Messages";
    private Long messages;
    public static final String JSON_PROPERTY_VERSION = "Version";
    private String version;

    public AppInformation database(String database) {
        this.database = database;
        return this;
    }

    @Nullable
    @JsonProperty(value="Database")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty(value="Database")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatabase(String database) {
        this.database = database;
    }

    public AppInformation databaseSize(Long databaseSize) {
        this.databaseSize = databaseSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="DatabaseSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDatabaseSize() {
        return this.databaseSize;
    }

    @JsonProperty(value="DatabaseSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatabaseSize(Long databaseSize) {
        this.databaseSize = databaseSize;
    }

    public AppInformation latestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="LatestVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @JsonProperty(value="LatestVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public AppInformation memory(Integer memory) {
        this.memory = memory;
        return this;
    }

    @Nullable
    @JsonProperty(value="Memory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMemory() {
        return this.memory;
    }

    @JsonProperty(value="Memory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public AppInformation messages(Long messages) {
        this.messages = messages;
        return this;
    }

    @Nullable
    @JsonProperty(value="Messages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMessages() {
        return this.messages;
    }

    @JsonProperty(value="Messages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessages(Long messages) {
        this.messages = messages;
    }

    public AppInformation version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="Version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="Version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppInformation appInformation = (AppInformation)o;
        return Objects.equals(this.database, appInformation.database) && Objects.equals(this.databaseSize, appInformation.databaseSize) && Objects.equals(this.latestVersion, appInformation.latestVersion) && Objects.equals(this.memory, appInformation.memory) && Objects.equals(this.messages, appInformation.messages) && Objects.equals(this.version, appInformation.version);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.databaseSize, this.latestVersion, this.memory, this.messages, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppInformation {\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    databaseSize: ").append(this.toIndentedString(this.databaseSize)).append("\n");
        sb.append("    latestVersion: ").append(this.toIndentedString(this.latestVersion)).append("\n");
        sb.append("    memory: ").append(this.toIndentedString(this.memory)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDatabase() != null) {
            joiner.add(String.format("%sDatabase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDatabase()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDatabaseSize() != null) {
            joiner.add(String.format("%sDatabaseSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDatabaseSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLatestVersion() != null) {
            joiner.add(String.format("%sLatestVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLatestVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMemory() != null) {
            joiner.add(String.format("%sMemory%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMemory()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMessages() != null) {
            joiner.add(String.format("%sMessages%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMessages()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVersion() != null) {
            joiner.add(String.format("%sVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

