/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.quarkiverse.mailpit.test.rest;

import io.quarkiverse.mailpit.test.invoker.ApiClient;
import io.quarkiverse.mailpit.test.invoker.ApiException;
import io.quarkiverse.mailpit.test.invoker.ApiResponse;
import io.quarkiverse.mailpit.test.invoker.Pair;

import io.quarkiverse.mailpit.test.model.Message;
import io.quarkiverse.mailpit.test.model.ReleaseMessageRequest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.6.0")
public class MessageApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public MessageApi() {
    this(new ApiClient());
  }

  public MessageApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * Get message attachment
   * This will return the attachment part using the appropriate Content-Type.
   * @param ID Database ID (required)
   * @param partID Attachment part ID (required)
   * @throws ApiException if fails to make API call
   */
  public void attachment(String ID, String partID) throws ApiException {
    attachmentWithHttpInfo(ID, partID);
  }

  /**
   * Get message attachment
   * This will return the attachment part using the appropriate Content-Type.
   * @param ID Database ID (required)
   * @param partID Attachment part ID (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> attachmentWithHttpInfo(String ID, String partID) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = attachmentRequestBuilder(ID, partID);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("attachment", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder attachmentRequestBuilder(String ID, String partID) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling attachment");
    }
    // verify the required parameter 'partID' is set
    if (partID == null) {
      throw new ApiException(400, "Missing the required parameter 'partID' when calling attachment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}/part/{PartID}"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()))
        .replace("{PartID}", ApiClient.urlEncode(partID.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get message headers
   * Returns the message headers as an array.
   * @param ID Database ID (required)
   * @return Map&lt;String, List&lt;String&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public Map<String, List<String>> headers(String ID) throws ApiException {
    ApiResponse<Map<String, List<String>>> localVarResponse = headersWithHttpInfo(ID);
    return localVarResponse.getData();
  }

  /**
   * Get message headers
   * Returns the message headers as an array.
   * @param ID Database ID (required)
   * @return ApiResponse&lt;Map&lt;String, List&lt;String&gt;&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Map<String, List<String>>> headersWithHttpInfo(String ID) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = headersRequestBuilder(ID);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("headers", localVarResponse);
        }
        return new ApiResponse<Map<String, List<String>>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Map<String, List<String>>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder headersRequestBuilder(String ID) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling headers");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}/headers"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get message summary
   * Returns the summary of a message, marking the message as read.
   * @param ID Database ID (required)
   * @return Message
   * @throws ApiException if fails to make API call
   */
  public Message message(String ID) throws ApiException {
    ApiResponse<Message> localVarResponse = messageWithHttpInfo(ID);
    return localVarResponse.getData();
  }

  /**
   * Get message summary
   * Returns the summary of a message, marking the message as read.
   * @param ID Database ID (required)
   * @return ApiResponse&lt;Message&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Message> messageWithHttpInfo(String ID) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = messageRequestBuilder(ID);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("message", localVarResponse);
        }
        return new ApiResponse<Message>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Message>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder messageRequestBuilder(String ID) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling message");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get message source
   * Returns the full email source as plain text.
   * @param ID Database ID (required)
   * @throws ApiException if fails to make API call
   */
  public void raw(String ID) throws ApiException {
    rawWithHttpInfo(ID);
  }

  /**
   * Get message source
   * Returns the full email source as plain text.
   * @param ID Database ID (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> rawWithHttpInfo(String ID) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = rawRequestBuilder(ID);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("raw", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder rawRequestBuilder(String ID) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling raw");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}/raw"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Release message
   * Release a message via a pre-configured external SMTP server..
   * @param ID Database ID (required)
   * @param to Array of email addresses to release message to (required)
   * @throws ApiException if fails to make API call
   */
  public void release(String ID, ReleaseMessageRequest to) throws ApiException {
    releaseWithHttpInfo(ID, to);
  }

  /**
   * Release message
   * Release a message via a pre-configured external SMTP server..
   * @param ID Database ID (required)
   * @param to Array of email addresses to release message to (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> releaseWithHttpInfo(String ID, ReleaseMessageRequest to) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = releaseRequestBuilder(ID, to);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("release", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder releaseRequestBuilder(String ID, ReleaseMessageRequest to) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling release");
    }
    // verify the required parameter 'to' is set
    if (to == null) {
      throw new ApiException(400, "Missing the required parameter 'to' when calling release");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}/release"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(to);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get an attachment image thumbnail
   * This will return a cropped 180x120 JPEG thumbnail of an image attachment. If the image is smaller than 180x120 then the image is padded. If the attachment is not an image then a blank image is returned.
   * @param ID Database ID (required)
   * @param partID Attachment part ID (required)
   * @throws ApiException if fails to make API call
   */
  public void thumbnail(String ID, String partID) throws ApiException {
    thumbnailWithHttpInfo(ID, partID);
  }

  /**
   * Get an attachment image thumbnail
   * This will return a cropped 180x120 JPEG thumbnail of an image attachment. If the image is smaller than 180x120 then the image is padded. If the attachment is not an image then a blank image is returned.
   * @param ID Database ID (required)
   * @param partID Attachment part ID (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> thumbnailWithHttpInfo(String ID, String partID) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = thumbnailRequestBuilder(ID, partID);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("thumbnail", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder thumbnailRequestBuilder(String ID, String partID) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling thumbnail");
    }
    // verify the required parameter 'partID' is set
    if (partID == null) {
      throw new ApiException(400, "Missing the required parameter 'partID' when calling thumbnail");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}/part/{PartID}/thumb"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()))
        .replace("{PartID}", ApiClient.urlEncode(partID.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

}
