/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkiverse.mailpit.test.model.WebUIConfigurationMessageRelay;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Response includes global web UI settings
 */
@JsonPropertyOrder({
  WebUIConfiguration.JSON_PROPERTY_DISABLE_H_T_M_L_CHECK,
  WebUIConfiguration.JSON_PROPERTY_MESSAGE_RELAY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.6.0")
public class WebUIConfiguration {
  public static final String JSON_PROPERTY_DISABLE_H_T_M_L_CHECK = "DisableHTMLCheck";
  private Boolean disableHTMLCheck;

  public static final String JSON_PROPERTY_MESSAGE_RELAY = "MessageRelay";
  private WebUIConfigurationMessageRelay messageRelay;

  public WebUIConfiguration() { 
  }

  public WebUIConfiguration disableHTMLCheck(Boolean disableHTMLCheck) {
    this.disableHTMLCheck = disableHTMLCheck;
    return this;
  }

   /**
   * Whether the HTML check has been globally disabled
   * @return disableHTMLCheck
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISABLE_H_T_M_L_CHECK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisableHTMLCheck() {
    return disableHTMLCheck;
  }


  @JsonProperty(JSON_PROPERTY_DISABLE_H_T_M_L_CHECK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisableHTMLCheck(Boolean disableHTMLCheck) {
    this.disableHTMLCheck = disableHTMLCheck;
  }


  public WebUIConfiguration messageRelay(WebUIConfigurationMessageRelay messageRelay) {
    this.messageRelay = messageRelay;
    return this;
  }

   /**
   * Get messageRelay
   * @return messageRelay
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE_RELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WebUIConfigurationMessageRelay getMessageRelay() {
    return messageRelay;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_RELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageRelay(WebUIConfigurationMessageRelay messageRelay) {
    this.messageRelay = messageRelay;
  }


  /**
   * Return true if this WebUIConfiguration object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebUIConfiguration webUIConfiguration = (WebUIConfiguration) o;
    return Objects.equals(this.disableHTMLCheck, webUIConfiguration.disableHTMLCheck) &&
        Objects.equals(this.messageRelay, webUIConfiguration.messageRelay);
  }

  @Override
  public int hashCode() {
    return Objects.hash(disableHTMLCheck, messageRelay);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebUIConfiguration {\n");
    sb.append("    disableHTMLCheck: ").append(toIndentedString(disableHTMLCheck)).append("\n");
    sb.append("    messageRelay: ").append(toIndentedString(messageRelay)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `DisableHTMLCheck` to the URL query string
    if (getDisableHTMLCheck() != null) {
      joiner.add(String.format("%sDisableHTMLCheck%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDisableHTMLCheck()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `MessageRelay` to the URL query string
    if (getMessageRelay() != null) {
      joiner.add(getMessageRelay().toUrlQueryString(prefix + "MessageRelay" + suffix));
    }

    return joiner.toString();
  }
}

