/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkiverse.mailpit.test.model.Address;
import io.quarkiverse.mailpit.test.model.Attachment;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Message data excluding physical attachments
 */
@JsonPropertyOrder({
  Message.JSON_PROPERTY_ATTACHMENTS,
  Message.JSON_PROPERTY_BCC,
  Message.JSON_PROPERTY_CC,
  Message.JSON_PROPERTY_DATE,
  Message.JSON_PROPERTY_FROM,
  Message.JSON_PROPERTY_H_T_M_L,
  Message.JSON_PROPERTY_I_D,
  Message.JSON_PROPERTY_INLINE,
  Message.JSON_PROPERTY_MESSAGE_I_D,
  Message.JSON_PROPERTY_REPLY_TO,
  Message.JSON_PROPERTY_RETURN_PATH,
  Message.JSON_PROPERTY_SIZE,
  Message.JSON_PROPERTY_SUBJECT,
  Message.JSON_PROPERTY_TAGS,
  Message.JSON_PROPERTY_TEXT,
  Message.JSON_PROPERTY_TO
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.6.0")
public class Message {
  public static final String JSON_PROPERTY_ATTACHMENTS = "Attachments";
  private List<Attachment> attachments = new ArrayList<>();

  public static final String JSON_PROPERTY_BCC = "Bcc";
  private List<Address> bcc = new ArrayList<>();

  public static final String JSON_PROPERTY_CC = "Cc";
  private List<Address> cc = new ArrayList<>();

  public static final String JSON_PROPERTY_DATE = "Date";
  private OffsetDateTime date;

  public static final String JSON_PROPERTY_FROM = "From";
  private Address from;

  public static final String JSON_PROPERTY_H_T_M_L = "HTML";
  private String HTML;

  public static final String JSON_PROPERTY_I_D = "ID";
  private String ID;

  public static final String JSON_PROPERTY_INLINE = "Inline";
  private List<Attachment> inline = new ArrayList<>();

  public static final String JSON_PROPERTY_MESSAGE_I_D = "MessageID";
  private String messageID;

  public static final String JSON_PROPERTY_REPLY_TO = "ReplyTo";
  private List<Address> replyTo = new ArrayList<>();

  public static final String JSON_PROPERTY_RETURN_PATH = "ReturnPath";
  private String returnPath;

  public static final String JSON_PROPERTY_SIZE = "Size";
  private Long size;

  public static final String JSON_PROPERTY_SUBJECT = "Subject";
  private String subject;

  public static final String JSON_PROPERTY_TAGS = "Tags";
  private List<String> tags = new ArrayList<>();

  public static final String JSON_PROPERTY_TEXT = "Text";
  private String text;

  public static final String JSON_PROPERTY_TO = "To";
  private List<Address> to = new ArrayList<>();

  public Message() { 
  }

  public Message attachments(List<Attachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  public Message addAttachmentsItem(Attachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

   /**
   * Message attachments
   * @return attachments
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Attachment> getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(List<Attachment> attachments) {
    this.attachments = attachments;
  }


  public Message bcc(List<Address> bcc) {
    this.bcc = bcc;
    return this;
  }

  public Message addBccItem(Address bccItem) {
    if (this.bcc == null) {
      this.bcc = new ArrayList<>();
    }
    this.bcc.add(bccItem);
    return this;
  }

   /**
   * Bcc addresses
   * @return bcc
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Address> getBcc() {
    return bcc;
  }


  @JsonProperty(JSON_PROPERTY_BCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBcc(List<Address> bcc) {
    this.bcc = bcc;
  }


  public Message cc(List<Address> cc) {
    this.cc = cc;
    return this;
  }

  public Message addCcItem(Address ccItem) {
    if (this.cc == null) {
      this.cc = new ArrayList<>();
    }
    this.cc.add(ccItem);
    return this;
  }

   /**
   * Cc addresses
   * @return cc
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Address> getCc() {
    return cc;
  }


  @JsonProperty(JSON_PROPERTY_CC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCc(List<Address> cc) {
    this.cc = cc;
  }


  public Message date(OffsetDateTime date) {
    this.date = date;
    return this;
  }

   /**
   * Message date if set, else date received
   * @return date
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(OffsetDateTime date) {
    this.date = date;
  }


  public Message from(Address from) {
    this.from = from;
    return this;
  }

   /**
   * Get from
   * @return from
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(Address from) {
    this.from = from;
  }


  public Message HTML(String HTML) {
    this.HTML = HTML;
    return this;
  }

   /**
   * Message body HTML
   * @return HTML
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_H_T_M_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHTML() {
    return HTML;
  }


  @JsonProperty(JSON_PROPERTY_H_T_M_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHTML(String HTML) {
    this.HTML = HTML;
  }


  public Message ID(String ID) {
    this.ID = ID;
    return this;
  }

   /**
   * Database ID
   * @return ID
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getID() {
    return ID;
  }


  @JsonProperty(JSON_PROPERTY_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setID(String ID) {
    this.ID = ID;
  }


  public Message inline(List<Attachment> inline) {
    this.inline = inline;
    return this;
  }

  public Message addInlineItem(Attachment inlineItem) {
    if (this.inline == null) {
      this.inline = new ArrayList<>();
    }
    this.inline.add(inlineItem);
    return this;
  }

   /**
   * Inline message attachments
   * @return inline
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Attachment> getInline() {
    return inline;
  }


  @JsonProperty(JSON_PROPERTY_INLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInline(List<Attachment> inline) {
    this.inline = inline;
  }


  public Message messageID(String messageID) {
    this.messageID = messageID;
    return this;
  }

   /**
   * Message ID
   * @return messageID
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageID() {
    return messageID;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageID(String messageID) {
    this.messageID = messageID;
  }


  public Message replyTo(List<Address> replyTo) {
    this.replyTo = replyTo;
    return this;
  }

  public Message addReplyToItem(Address replyToItem) {
    if (this.replyTo == null) {
      this.replyTo = new ArrayList<>();
    }
    this.replyTo.add(replyToItem);
    return this;
  }

   /**
   * ReplyTo addresses
   * @return replyTo
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Address> getReplyTo() {
    return replyTo;
  }


  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReplyTo(List<Address> replyTo) {
    this.replyTo = replyTo;
  }


  public Message returnPath(String returnPath) {
    this.returnPath = returnPath;
    return this;
  }

   /**
   * Return-Path
   * @return returnPath
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RETURN_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnPath() {
    return returnPath;
  }


  @JsonProperty(JSON_PROPERTY_RETURN_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReturnPath(String returnPath) {
    this.returnPath = returnPath;
  }


  public Message size(Long size) {
    this.size = size;
    return this;
  }

   /**
   * Message size in bytes
   * @return size
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSize(Long size) {
    this.size = size;
  }


  public Message subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Message subject
   * @return subject
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public Message tags(List<String> tags) {
    this.tags = tags;
    return this;
  }

  public Message addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Message tags
   * @return tags
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  public Message text(String text) {
    this.text = text;
    return this;
  }

   /**
   * Message body text
   * @return text
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public Message to(List<Address> to) {
    this.to = to;
    return this;
  }

  public Message addToItem(Address toItem) {
    if (this.to == null) {
      this.to = new ArrayList<>();
    }
    this.to.add(toItem);
    return this;
  }

   /**
   * To addresses
   * @return to
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Address> getTo() {
    return to;
  }


  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTo(List<Address> to) {
    this.to = to;
  }


  /**
   * Return true if this Message object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Message message = (Message) o;
    return Objects.equals(this.attachments, message.attachments) &&
        Objects.equals(this.bcc, message.bcc) &&
        Objects.equals(this.cc, message.cc) &&
        Objects.equals(this.date, message.date) &&
        Objects.equals(this.from, message.from) &&
        Objects.equals(this.HTML, message.HTML) &&
        Objects.equals(this.ID, message.ID) &&
        Objects.equals(this.inline, message.inline) &&
        Objects.equals(this.messageID, message.messageID) &&
        Objects.equals(this.replyTo, message.replyTo) &&
        Objects.equals(this.returnPath, message.returnPath) &&
        Objects.equals(this.size, message.size) &&
        Objects.equals(this.subject, message.subject) &&
        Objects.equals(this.tags, message.tags) &&
        Objects.equals(this.text, message.text) &&
        Objects.equals(this.to, message.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attachments, bcc, cc, date, from, HTML, ID, inline, messageID, replyTo, returnPath, size, subject, tags, text, to);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Message {\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    HTML: ").append(toIndentedString(HTML)).append("\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    inline: ").append(toIndentedString(inline)).append("\n");
    sb.append("    messageID: ").append(toIndentedString(messageID)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    returnPath: ").append(toIndentedString(returnPath)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `Attachments` to the URL query string
    if (getAttachments() != null) {
      for (int i = 0; i < getAttachments().size(); i++) {
        if (getAttachments().get(i) != null) {
          joiner.add(getAttachments().get(i).toUrlQueryString(String.format("%sAttachments%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `Bcc` to the URL query string
    if (getBcc() != null) {
      for (int i = 0; i < getBcc().size(); i++) {
        if (getBcc().get(i) != null) {
          joiner.add(getBcc().get(i).toUrlQueryString(String.format("%sBcc%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `Cc` to the URL query string
    if (getCc() != null) {
      for (int i = 0; i < getCc().size(); i++) {
        if (getCc().get(i) != null) {
          joiner.add(getCc().get(i).toUrlQueryString(String.format("%sCc%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `Date` to the URL query string
    if (getDate() != null) {
      joiner.add(String.format("%sDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `From` to the URL query string
    if (getFrom() != null) {
      joiner.add(getFrom().toUrlQueryString(prefix + "From" + suffix));
    }

    // add `HTML` to the URL query string
    if (getHTML() != null) {
      joiner.add(String.format("%sHTML%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHTML()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ID` to the URL query string
    if (getID() != null) {
      joiner.add(String.format("%sID%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getID()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Inline` to the URL query string
    if (getInline() != null) {
      for (int i = 0; i < getInline().size(); i++) {
        if (getInline().get(i) != null) {
          joiner.add(getInline().get(i).toUrlQueryString(String.format("%sInline%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `MessageID` to the URL query string
    if (getMessageID() != null) {
      joiner.add(String.format("%sMessageID%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessageID()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ReplyTo` to the URL query string
    if (getReplyTo() != null) {
      for (int i = 0; i < getReplyTo().size(); i++) {
        if (getReplyTo().get(i) != null) {
          joiner.add(getReplyTo().get(i).toUrlQueryString(String.format("%sReplyTo%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `ReturnPath` to the URL query string
    if (getReturnPath() != null) {
      joiner.add(String.format("%sReturnPath%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReturnPath()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Size` to the URL query string
    if (getSize() != null) {
      joiner.add(String.format("%sSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Subject` to the URL query string
    if (getSubject() != null) {
      joiner.add(String.format("%sSubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubject()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Tags` to the URL query string
    if (getTags() != null) {
      for (int i = 0; i < getTags().size(); i++) {
        joiner.add(String.format("%sTags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getTags().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `Text` to the URL query string
    if (getText() != null) {
      joiner.add(String.format("%sText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getText()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `To` to the URL query string
    if (getTo() != null) {
      for (int i = 0; i < getTo().size(); i++) {
        if (getTo().get(i) != null) {
          joiner.add(getTo().get(i).toUrlQueryString(String.format("%sTo%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

