/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Total weighted result for all scores
 */
@JsonPropertyOrder({
  HTMLCheckTotal.JSON_PROPERTY_NODES,
  HTMLCheckTotal.JSON_PROPERTY_PARTIAL,
  HTMLCheckTotal.JSON_PROPERTY_SUPPORTED,
  HTMLCheckTotal.JSON_PROPERTY_TESTS,
  HTMLCheckTotal.JSON_PROPERTY_UNSUPPORTED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.6.0")
public class HTMLCheckTotal {
  public static final String JSON_PROPERTY_NODES = "Nodes";
  private Long nodes;

  public static final String JSON_PROPERTY_PARTIAL = "Partial";
  private Float partial;

  public static final String JSON_PROPERTY_SUPPORTED = "Supported";
  private Float supported;

  public static final String JSON_PROPERTY_TESTS = "Tests";
  private Long tests;

  public static final String JSON_PROPERTY_UNSUPPORTED = "Unsupported";
  private Float unsupported;

  public HTMLCheckTotal() { 
  }

  public HTMLCheckTotal nodes(Long nodes) {
    this.nodes = nodes;
    return this;
  }

   /**
   * Total number of HTML nodes detected in message
   * @return nodes
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNodes() {
    return nodes;
  }


  @JsonProperty(JSON_PROPERTY_NODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNodes(Long nodes) {
    this.nodes = nodes;
  }


  public HTMLCheckTotal partial(Float partial) {
    this.partial = partial;
    return this;
  }

   /**
   * Overall percentage partially supported
   * @return partial
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARTIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPartial() {
    return partial;
  }


  @JsonProperty(JSON_PROPERTY_PARTIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartial(Float partial) {
    this.partial = partial;
  }


  public HTMLCheckTotal supported(Float supported) {
    this.supported = supported;
    return this;
  }

   /**
   * Overall percentage supported
   * @return supported
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getSupported() {
    return supported;
  }


  @JsonProperty(JSON_PROPERTY_SUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupported(Float supported) {
    this.supported = supported;
  }


  public HTMLCheckTotal tests(Long tests) {
    this.tests = tests;
    return this;
  }

   /**
   * Total number of tests done
   * @return tests
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTests() {
    return tests;
  }


  @JsonProperty(JSON_PROPERTY_TESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTests(Long tests) {
    this.tests = tests;
  }


  public HTMLCheckTotal unsupported(Float unsupported) {
    this.unsupported = unsupported;
    return this;
  }

   /**
   * Overall percentage unsupported
   * @return unsupported
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNSUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getUnsupported() {
    return unsupported;
  }


  @JsonProperty(JSON_PROPERTY_UNSUPPORTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnsupported(Float unsupported) {
    this.unsupported = unsupported;
  }


  /**
   * Return true if this HTMLCheckTotal object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HTMLCheckTotal htMLCheckTotal = (HTMLCheckTotal) o;
    return Objects.equals(this.nodes, htMLCheckTotal.nodes) &&
        Objects.equals(this.partial, htMLCheckTotal.partial) &&
        Objects.equals(this.supported, htMLCheckTotal.supported) &&
        Objects.equals(this.tests, htMLCheckTotal.tests) &&
        Objects.equals(this.unsupported, htMLCheckTotal.unsupported);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nodes, partial, supported, tests, unsupported);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HTMLCheckTotal {\n");
    sb.append("    nodes: ").append(toIndentedString(nodes)).append("\n");
    sb.append("    partial: ").append(toIndentedString(partial)).append("\n");
    sb.append("    supported: ").append(toIndentedString(supported)).append("\n");
    sb.append("    tests: ").append(toIndentedString(tests)).append("\n");
    sb.append("    unsupported: ").append(toIndentedString(unsupported)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `Nodes` to the URL query string
    if (getNodes() != null) {
      joiner.add(String.format("%sNodes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNodes()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Partial` to the URL query string
    if (getPartial() != null) {
      joiner.add(String.format("%sPartial%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPartial()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Supported` to the URL query string
    if (getSupported() != null) {
      joiner.add(String.format("%sSupported%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSupported()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Tests` to the URL query string
    if (getTests() != null) {
      joiner.add(String.format("%sTests%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTests()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Unsupported` to the URL query string
    if (getUnsupported() != null) {
      joiner.add(String.format("%sUnsupported%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnsupported()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

