/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Result struct
 */
@JsonPropertyOrder({
  HTMLCheckResult.JSON_PROPERTY_FAMILY,
  HTMLCheckResult.JSON_PROPERTY_NAME,
  HTMLCheckResult.JSON_PROPERTY_NOTE_NUMBER,
  HTMLCheckResult.JSON_PROPERTY_PLATFORM,
  HTMLCheckResult.JSON_PROPERTY_SUPPORT,
  HTMLCheckResult.JSON_PROPERTY_VERSION
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.6.0")
public class HTMLCheckResult {
  public static final String JSON_PROPERTY_FAMILY = "Family";
  private String family;

  public static final String JSON_PROPERTY_NAME = "Name";
  private String name;

  public static final String JSON_PROPERTY_NOTE_NUMBER = "NoteNumber";
  private String noteNumber;

  public static final String JSON_PROPERTY_PLATFORM = "Platform";
  private String platform;

  public static final String JSON_PROPERTY_SUPPORT = "Support";
  private String support;

  public static final String JSON_PROPERTY_VERSION = "Version";
  private String version;

  public HTMLCheckResult() { 
  }

  public HTMLCheckResult family(String family) {
    this.family = family;
    return this;
  }

   /**
   * Family eg: Outlook, Mozilla Thunderbird
   * @return family
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFamily() {
    return family;
  }


  @JsonProperty(JSON_PROPERTY_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFamily(String family) {
    this.family = family;
  }


  public HTMLCheckResult name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Friendly name of result, combining family, platform &amp; version
   * @return name
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public HTMLCheckResult noteNumber(String noteNumber) {
    this.noteNumber = noteNumber;
    return this;
  }

   /**
   * Note number for partially supported if applicable
   * @return noteNumber
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NOTE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNoteNumber() {
    return noteNumber;
  }


  @JsonProperty(JSON_PROPERTY_NOTE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoteNumber(String noteNumber) {
    this.noteNumber = noteNumber;
  }


  public HTMLCheckResult platform(String platform) {
    this.platform = platform;
    return this;
  }

   /**
   * Platform eg: ios, android, windows
   * @return platform
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPlatform() {
    return platform;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatform(String platform) {
    this.platform = platform;
  }


  public HTMLCheckResult support(String support) {
    this.support = support;
    return this;
  }

   /**
   * Support [yes, no, partial]
   * @return support
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUPPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupport() {
    return support;
  }


  @JsonProperty(JSON_PROPERTY_SUPPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupport(String support) {
    this.support = support;
  }


  public HTMLCheckResult version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Family version eg: 4.7.1, 2019-10, 10.3
   * @return version
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(String version) {
    this.version = version;
  }


  /**
   * Return true if this HTMLCheckResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HTMLCheckResult htMLCheckResult = (HTMLCheckResult) o;
    return Objects.equals(this.family, htMLCheckResult.family) &&
        Objects.equals(this.name, htMLCheckResult.name) &&
        Objects.equals(this.noteNumber, htMLCheckResult.noteNumber) &&
        Objects.equals(this.platform, htMLCheckResult.platform) &&
        Objects.equals(this.support, htMLCheckResult.support) &&
        Objects.equals(this.version, htMLCheckResult.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(family, name, noteNumber, platform, support, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HTMLCheckResult {\n");
    sb.append("    family: ").append(toIndentedString(family)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    noteNumber: ").append(toIndentedString(noteNumber)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("    support: ").append(toIndentedString(support)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `Family` to the URL query string
    if (getFamily() != null) {
      joiner.add(String.format("%sFamily%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFamily()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `NoteNumber` to the URL query string
    if (getNoteNumber() != null) {
      joiner.add(String.format("%sNoteNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNoteNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Platform` to the URL query string
    if (getPlatform() != null) {
      joiner.add(String.format("%sPlatform%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPlatform()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Support` to the URL query string
    if (getSupport() != null) {
      joiner.add(String.format("%sSupport%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSupport()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Version` to the URL query string
    if (getVersion() != null) {
      joiner.add(String.format("%sVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

