/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Response includes the current and latest Mailpit version, database info, and memory usage
 */
@JsonPropertyOrder({
  AppInformation.JSON_PROPERTY_DATABASE,
  AppInformation.JSON_PROPERTY_DATABASE_SIZE,
  AppInformation.JSON_PROPERTY_LATEST_VERSION,
  AppInformation.JSON_PROPERTY_MEMORY,
  AppInformation.JSON_PROPERTY_MESSAGES,
  AppInformation.JSON_PROPERTY_VERSION
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.6.0")
public class AppInformation {
  public static final String JSON_PROPERTY_DATABASE = "Database";
  private String database;

  public static final String JSON_PROPERTY_DATABASE_SIZE = "DatabaseSize";
  private Long databaseSize;

  public static final String JSON_PROPERTY_LATEST_VERSION = "LatestVersion";
  private String latestVersion;

  public static final String JSON_PROPERTY_MEMORY = "Memory";
  private Integer memory;

  public static final String JSON_PROPERTY_MESSAGES = "Messages";
  private Long messages;

  public static final String JSON_PROPERTY_VERSION = "Version";
  private String version;

  public AppInformation() { 
  }

  public AppInformation database(String database) {
    this.database = database;
    return this;
  }

   /**
   * Database path
   * @return database
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATABASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDatabase() {
    return database;
  }


  @JsonProperty(JSON_PROPERTY_DATABASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDatabase(String database) {
    this.database = database;
  }


  public AppInformation databaseSize(Long databaseSize) {
    this.databaseSize = databaseSize;
    return this;
  }

   /**
   * Database size in bytes
   * @return databaseSize
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATABASE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDatabaseSize() {
    return databaseSize;
  }


  @JsonProperty(JSON_PROPERTY_DATABASE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDatabaseSize(Long databaseSize) {
    this.databaseSize = databaseSize;
  }


  public AppInformation latestVersion(String latestVersion) {
    this.latestVersion = latestVersion;
    return this;
  }

   /**
   * Latest Mailpit version
   * @return latestVersion
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LATEST_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLatestVersion() {
    return latestVersion;
  }


  @JsonProperty(JSON_PROPERTY_LATEST_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatestVersion(String latestVersion) {
    this.latestVersion = latestVersion;
  }


  public AppInformation memory(Integer memory) {
    this.memory = memory;
    return this;
  }

   /**
   * Current memory usage in bytes
   * @return memory
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MEMORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMemory() {
    return memory;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemory(Integer memory) {
    this.memory = memory;
  }


  public AppInformation messages(Long messages) {
    this.messages = messages;
    return this;
  }

   /**
   * Total number of messages in the database
   * @return messages
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMessages() {
    return messages;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessages(Long messages) {
    this.messages = messages;
  }


  public AppInformation version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Current Mailpit version
   * @return version
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(String version) {
    this.version = version;
  }


  /**
   * Return true if this AppInformation object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppInformation appInformation = (AppInformation) o;
    return Objects.equals(this.database, appInformation.database) &&
        Objects.equals(this.databaseSize, appInformation.databaseSize) &&
        Objects.equals(this.latestVersion, appInformation.latestVersion) &&
        Objects.equals(this.memory, appInformation.memory) &&
        Objects.equals(this.messages, appInformation.messages) &&
        Objects.equals(this.version, appInformation.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(database, databaseSize, latestVersion, memory, messages, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppInformation {\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    databaseSize: ").append(toIndentedString(databaseSize)).append("\n");
    sb.append("    latestVersion: ").append(toIndentedString(latestVersion)).append("\n");
    sb.append("    memory: ").append(toIndentedString(memory)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `Database` to the URL query string
    if (getDatabase() != null) {
      joiner.add(String.format("%sDatabase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDatabase()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `DatabaseSize` to the URL query string
    if (getDatabaseSize() != null) {
      joiner.add(String.format("%sDatabaseSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDatabaseSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `LatestVersion` to the URL query string
    if (getLatestVersion() != null) {
      joiner.add(String.format("%sLatestVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLatestVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Memory` to the URL query string
    if (getMemory() != null) {
      joiner.add(String.format("%sMemory%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMemory()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Messages` to the URL query string
    if (getMessages() != null) {
      joiner.add(String.format("%sMessages%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessages()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Version` to the URL query string
    if (getVersion() != null) {
      joiner.add(String.format("%sVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

