/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.quarkiverse.mailpit.test.model.HTMLCheckResult;
import io.quarkiverse.mailpit.test.model.HTMLCheckScore;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"Category", "Description", "Keywords", "NotesByNumber", "Results", "Score", "Slug", "Tags", "Title", "URL"})
public class HTMLCheckWarning {
    public static final String JSON_PROPERTY_CATEGORY = "Category";
    private String category;
    public static final String JSON_PROPERTY_DESCRIPTION = "Description";
    private String description;
    public static final String JSON_PROPERTY_KEYWORDS = "Keywords";
    private String keywords;
    public static final String JSON_PROPERTY_NOTES_BY_NUMBER = "NotesByNumber";
    private Map<String, String> notesByNumber = new HashMap<String, String>();
    public static final String JSON_PROPERTY_RESULTS = "Results";
    private List<HTMLCheckResult> results = new ArrayList<HTMLCheckResult>();
    public static final String JSON_PROPERTY_SCORE = "Score";
    private HTMLCheckScore score;
    public static final String JSON_PROPERTY_SLUG = "Slug";
    private String slug;
    public static final String JSON_PROPERTY_TAGS = "Tags";
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_TITLE = "Title";
    private String title;
    public static final String JSON_PROPERTY_U_R_L = "URL";
    private String URL;

    public HTMLCheckWarning category(String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @JsonProperty(value="Category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="Category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(String category) {
        this.category = category;
    }

    public HTMLCheckWarning description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="Description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="Description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public HTMLCheckWarning keywords(String keywords) {
        this.keywords = keywords;
        return this;
    }

    @Nullable
    @JsonProperty(value="Keywords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="Keywords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public HTMLCheckWarning notesByNumber(Map<String, String> notesByNumber) {
        this.notesByNumber = notesByNumber;
        return this;
    }

    public HTMLCheckWarning putNotesByNumberItem(String key, String notesByNumberItem) {
        if (this.notesByNumber == null) {
            this.notesByNumber = new HashMap<String, String>();
        }
        this.notesByNumber.put(key, notesByNumberItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="NotesByNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getNotesByNumber() {
        return this.notesByNumber;
    }

    @JsonProperty(value="NotesByNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotesByNumber(Map<String, String> notesByNumber) {
        this.notesByNumber = notesByNumber;
    }

    public HTMLCheckWarning results(List<HTMLCheckResult> results) {
        this.results = results;
        return this;
    }

    public HTMLCheckWarning addResultsItem(HTMLCheckResult resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<HTMLCheckResult>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HTMLCheckResult> getResults() {
        return this.results;
    }

    @JsonProperty(value="Results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResults(List<HTMLCheckResult> results) {
        this.results = results;
    }

    public HTMLCheckWarning score(HTMLCheckScore score) {
        this.score = score;
        return this;
    }

    @Nullable
    @JsonProperty(value="Score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HTMLCheckScore getScore() {
        return this.score;
    }

    @JsonProperty(value="Score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScore(HTMLCheckScore score) {
        this.score = score;
    }

    public HTMLCheckWarning slug(String slug) {
        this.slug = slug;
        return this;
    }

    @Nullable
    @JsonProperty(value="Slug")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSlug() {
        return this.slug;
    }

    @JsonProperty(value="Slug")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSlug(String slug) {
        this.slug = slug;
    }

    public HTMLCheckWarning tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public HTMLCheckWarning addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="Tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public HTMLCheckWarning title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="Title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="Title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public HTMLCheckWarning URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @Nullable
    @JsonProperty(value="URL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getURL() {
        return this.URL;
    }

    @JsonProperty(value="URL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTMLCheckWarning htMLCheckWarning = (HTMLCheckWarning)o;
        return Objects.equals(this.category, htMLCheckWarning.category) && Objects.equals(this.description, htMLCheckWarning.description) && Objects.equals(this.keywords, htMLCheckWarning.keywords) && Objects.equals(this.notesByNumber, htMLCheckWarning.notesByNumber) && Objects.equals(this.results, htMLCheckWarning.results) && Objects.equals(this.score, htMLCheckWarning.score) && Objects.equals(this.slug, htMLCheckWarning.slug) && Objects.equals(this.tags, htMLCheckWarning.tags) && Objects.equals(this.title, htMLCheckWarning.title) && Objects.equals(this.URL, htMLCheckWarning.URL);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.description, this.keywords, this.notesByNumber, this.results, this.score, this.slug, this.tags, this.title, this.URL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTMLCheckWarning {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    notesByNumber: ").append(this.toIndentedString(this.notesByNumber)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    slug: ").append(this.toIndentedString(this.slug)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCategory() != null) {
            joiner.add(String.format("%sCategory%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCategory()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sDescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getKeywords() != null) {
            joiner.add(String.format("%sKeywords%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getKeywords()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNotesByNumber() != null) {
            for (String _key : this.getNotesByNumber().keySet()) {
                joiner.add(String.format("%sNotesByNumber%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getNotesByNumber().get(_key), URLEncoder.encode(String.valueOf(this.getNotesByNumber().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getResults() != null) {
            for (int i = 0; i < this.getResults().size(); ++i) {
                if (this.getResults().get(i) == null) continue;
                joiner.add(this.getResults().get(i).toUrlQueryString(String.format("%sResults%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getScore() != null) {
            joiner.add(this.getScore().toUrlQueryString((String)prefix + JSON_PROPERTY_SCORE + suffix));
        }
        if (this.getSlug() != null) {
            joiner.add(String.format("%sSlug%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSlug()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (int i = 0; i < this.getTags().size(); ++i) {
                joiner.add(String.format("%sTags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTags().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getTitle() != null) {
            joiner.add(String.format("%sTitle%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTitle()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getURL() != null) {
            joiner.add(String.format("%sURL%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getURL()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

