/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.quarkiverse.mailpit.test.rest;

import io.quarkiverse.mailpit.test.invoker.ApiClient;
import io.quarkiverse.mailpit.test.invoker.ApiException;
import io.quarkiverse.mailpit.test.invoker.ApiResponse;
import io.quarkiverse.mailpit.test.invoker.Pair;

import io.quarkiverse.mailpit.test.model.HTMLCheckResponse;
import io.quarkiverse.mailpit.test.model.LinkCheckResponse;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.5.0")
public class OtherApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public OtherApi() {
    this(new ApiClient());
  }

  public OtherApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * HTML check (beta)
   * Returns the summary of the message HTML checker.  NOTE: This feature is currently in beta and is documented for reference only. Please do not integrate with it (yet) as there may be changes.
   * @param ID Database ID (required)
   * @return HTMLCheckResponse
   * @throws ApiException if fails to make API call
   */
  public HTMLCheckResponse hTMLCheckResponse(String ID) throws ApiException {
    ApiResponse<HTMLCheckResponse> localVarResponse = hTMLCheckResponseWithHttpInfo(ID);
    return localVarResponse.getData();
  }

  /**
   * HTML check (beta)
   * Returns the summary of the message HTML checker.  NOTE: This feature is currently in beta and is documented for reference only. Please do not integrate with it (yet) as there may be changes.
   * @param ID Database ID (required)
   * @return ApiResponse&lt;HTMLCheckResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<HTMLCheckResponse> hTMLCheckResponseWithHttpInfo(String ID) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = hTMLCheckResponseRequestBuilder(ID);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("hTMLCheckResponse", localVarResponse);
        }
        return new ApiResponse<HTMLCheckResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<HTMLCheckResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder hTMLCheckResponseRequestBuilder(String ID) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling hTMLCheckResponse");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}/html-check"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Link check (beta)
   * Returns the summary of the message Link checker.  NOTE: This feature is currently in beta and is documented for reference only. Please do not integrate with it (yet) as there may be changes.
   * @param ID Database ID (required)
   * @param follow Follow redirects (optional, default to false)
   * @return LinkCheckResponse
   * @throws ApiException if fails to make API call
   */
  public LinkCheckResponse linkCheckResponse(String ID, Boolean follow) throws ApiException {
    ApiResponse<LinkCheckResponse> localVarResponse = linkCheckResponseWithHttpInfo(ID, follow);
    return localVarResponse.getData();
  }

  /**
   * Link check (beta)
   * Returns the summary of the message Link checker.  NOTE: This feature is currently in beta and is documented for reference only. Please do not integrate with it (yet) as there may be changes.
   * @param ID Database ID (required)
   * @param follow Follow redirects (optional, default to false)
   * @return ApiResponse&lt;LinkCheckResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<LinkCheckResponse> linkCheckResponseWithHttpInfo(String ID, Boolean follow) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = linkCheckResponseRequestBuilder(ID, follow);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("linkCheckResponse", localVarResponse);
        }
        return new ApiResponse<LinkCheckResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<LinkCheckResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder linkCheckResponseRequestBuilder(String ID, Boolean follow) throws ApiException {
    // verify the required parameter 'ID' is set
    if (ID == null) {
      throw new ApiException(400, "Missing the required parameter 'ID' when calling linkCheckResponse");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/api/v1/message/{ID}/link-check"
        .replace("{ID}", ApiClient.urlEncode(ID.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "follow";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("follow", follow));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

}
