/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mailpit.test.invoker.ApiClient;
import io.quarkiverse.mailpit.test.invoker.ApiException;
import io.quarkiverse.mailpit.test.invoker.ApiResponse;
import io.quarkiverse.mailpit.test.model.SetTagsRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;

public class TagsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public TagsApi() {
        this(new ApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public List<String> setTags() throws ApiException {
        ApiResponse<List<String>> localVarResponse = this.setTagsWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<List<String>> setTagsWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.setTagsRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setTags", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<String>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder setTagsRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/tags";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void setTags_0(SetTagsRequest ids) throws ApiException {
        this.setTags_0WithHttpInfo(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> setTags_0WithHttpInfo(SetTagsRequest ids) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.setTags_0RequestBuilder(ids);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setTags_0", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder setTags_0RequestBuilder(SetTagsRequest ids) throws ApiException {
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling setTags_0");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/tags";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)ids);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

