/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.quarkiverse.mailpit.test.model.Link;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"Errors", "Links"})
public class LinkCheckResponse {
    public static final String JSON_PROPERTY_ERRORS = "Errors";
    private Long errors;
    public static final String JSON_PROPERTY_LINKS = "Links";
    private List<Link> links;

    public LinkCheckResponse errors(Long errors) {
        this.errors = errors;
        return this;
    }

    @Nullable
    @JsonProperty(value="Errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getErrors() {
        return this.errors;
    }

    @JsonProperty(value="Errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(Long errors) {
        this.errors = errors;
    }

    public LinkCheckResponse links(List<Link> links) {
        this.links = links;
        return this;
    }

    public LinkCheckResponse addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="Links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkCheckResponse linkCheckResponse = (LinkCheckResponse)o;
        return Objects.equals(this.errors, linkCheckResponse.errors) && Objects.equals(this.links, linkCheckResponse.links);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkCheckResponse {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getErrors() != null) {
            joiner.add(String.format("%sErrors%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrors()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLinks() != null) {
            for (int i = 0; i < this.getLinks().size(); ++i) {
                if (this.getLinks().get(i) == null) continue;
                joiner.add(this.getLinks().get(i).toUrlQueryString(String.format("%sLinks%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

