/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkiverse.mailpit.test.model.HTMLCheckTotal;
import io.quarkiverse.mailpit.test.model.HTMLCheckWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Response represents the HTML check response struct
 */
@JsonPropertyOrder({
  HTMLCheckResponse.JSON_PROPERTY_PLATFORMS,
  HTMLCheckResponse.JSON_PROPERTY_TOTAL,
  HTMLCheckResponse.JSON_PROPERTY_WARNINGS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class HTMLCheckResponse {
  public static final String JSON_PROPERTY_PLATFORMS = "Platforms";
  private Map<String, List<String>> platforms = new HashMap<>();

  public static final String JSON_PROPERTY_TOTAL = "Total";
  private HTMLCheckTotal total;

  public static final String JSON_PROPERTY_WARNINGS = "Warnings";
  private List<HTMLCheckWarning> warnings;

  public HTMLCheckResponse() { 
  }

  public HTMLCheckResponse platforms(Map<String, List<String>> platforms) {
    this.platforms = platforms;
    return this;
  }

  public HTMLCheckResponse putPlatformsItem(String key, List<String> platformsItem) {
    if (this.platforms == null) {
      this.platforms = new HashMap<>();
    }
    this.platforms.put(key, platformsItem);
    return this;
  }

   /**
   * All platforms tested, mainly for the web UI
   * @return platforms
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PLATFORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, List<String>> getPlatforms() {
    return platforms;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatforms(Map<String, List<String>> platforms) {
    this.platforms = platforms;
  }


  public HTMLCheckResponse total(HTMLCheckTotal total) {
    this.total = total;
    return this;
  }

   /**
   * Get total
   * @return total
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HTMLCheckTotal getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(HTMLCheckTotal total) {
    this.total = total;
  }


  public HTMLCheckResponse warnings(List<HTMLCheckWarning> warnings) {
    this.warnings = warnings;
    return this;
  }

  public HTMLCheckResponse addWarningsItem(HTMLCheckWarning warningsItem) {
    if (this.warnings == null) {
      this.warnings = new ArrayList<>();
    }
    this.warnings.add(warningsItem);
    return this;
  }

   /**
   * List of warnings from tests
   * @return warnings
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WARNINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<HTMLCheckWarning> getWarnings() {
    return warnings;
  }


  @JsonProperty(JSON_PROPERTY_WARNINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWarnings(List<HTMLCheckWarning> warnings) {
    this.warnings = warnings;
  }


  /**
   * Return true if this HTMLCheckResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HTMLCheckResponse htMLCheckResponse = (HTMLCheckResponse) o;
    return Objects.equals(this.platforms, htMLCheckResponse.platforms) &&
        Objects.equals(this.total, htMLCheckResponse.total) &&
        Objects.equals(this.warnings, htMLCheckResponse.warnings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(platforms, total, warnings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HTMLCheckResponse {\n");
    sb.append("    platforms: ").append(toIndentedString(platforms)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    warnings: ").append(toIndentedString(warnings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `Platforms` to the URL query string
    if (getPlatforms() != null) {
      for (String _key : getPlatforms().keySet()) {
        joiner.add(String.format("%sPlatforms%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getPlatforms().get(_key), URLEncoder.encode(String.valueOf(getPlatforms().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `Total` to the URL query string
    if (getTotal() != null) {
      joiner.add(getTotal().toUrlQueryString(prefix + "Total" + suffix));
    }

    // add `Warnings` to the URL query string
    if (getWarnings() != null) {
      for (int i = 0; i < getWarnings().size(); i++) {
        if (getWarnings().get(i) != null) {
          joiner.add(getWarnings().get(i).toUrlQueryString(String.format("%sWarnings%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

