/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"to"})
public class ReleaseMessageRequest {
    public static final String JSON_PROPERTY_TO = "to";
    private List<String> to;

    public ReleaseMessageRequest to(List<String> to) {
        this.to = to;
        return this;
    }

    public ReleaseMessageRequest addToItem(String toItem) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTo(List<String> to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseMessageRequest releaseMessageRequest = (ReleaseMessageRequest)o;
        return Objects.equals(this.to, releaseMessageRequest.to);
    }

    public int hashCode() {
        return Objects.hash(this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReleaseMessageRequest {\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTo() != null) {
            for (int i = 0; i < this.getTo().size(); ++i) {
                joiner.add(String.format("%sto%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTo().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

