/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.quarkiverse.mailpit.test.model.Address;
import io.quarkiverse.mailpit.test.model.Attachment;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"Attachments", "Bcc", "Cc", "Date", "From", "HTML", "ID", "Inline", "MessageID", "ReplyTo", "ReturnPath", "Size", "Subject", "Tags", "Text", "To"})
public class Message {
    public static final String JSON_PROPERTY_ATTACHMENTS = "Attachments";
    private List<Attachment> attachments;
    public static final String JSON_PROPERTY_BCC = "Bcc";
    private List<Address> bcc;
    public static final String JSON_PROPERTY_CC = "Cc";
    private List<Address> cc;
    public static final String JSON_PROPERTY_DATE = "Date";
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_FROM = "From";
    private Address from;
    public static final String JSON_PROPERTY_H_T_M_L = "HTML";
    private String HTML;
    public static final String JSON_PROPERTY_I_D = "ID";
    private String ID;
    public static final String JSON_PROPERTY_INLINE = "Inline";
    private List<Attachment> inline;
    public static final String JSON_PROPERTY_MESSAGE_I_D = "MessageID";
    private String messageID;
    public static final String JSON_PROPERTY_REPLY_TO = "ReplyTo";
    private List<Address> replyTo;
    public static final String JSON_PROPERTY_RETURN_PATH = "ReturnPath";
    private String returnPath;
    public static final String JSON_PROPERTY_SIZE = "Size";
    private Long size;
    public static final String JSON_PROPERTY_SUBJECT = "Subject";
    private String subject;
    public static final String JSON_PROPERTY_TAGS = "Tags";
    private List<String> tags;
    public static final String JSON_PROPERTY_TEXT = "Text";
    private String text;
    public static final String JSON_PROPERTY_TO = "To";
    private List<Address> to;

    public Message attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Message addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="Attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Message bcc(List<Address> bcc) {
        this.bcc = bcc;
        return this;
    }

    public Message addBccItem(Address bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<Address>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Bcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Address> getBcc() {
        return this.bcc;
    }

    @JsonProperty(value="Bcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBcc(List<Address> bcc) {
        this.bcc = bcc;
    }

    public Message cc(List<Address> cc) {
        this.cc = cc;
        return this;
    }

    public Message addCcItem(Address ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<Address>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Cc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Address> getCc() {
        return this.cc;
    }

    @JsonProperty(value="Cc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCc(List<Address> cc) {
        this.cc = cc;
    }

    public Message date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    @JsonProperty(value="Date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    @JsonProperty(value="Date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public Message from(Address from) {
        this.from = from;
        return this;
    }

    @Nullable
    @JsonProperty(value="From")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getFrom() {
        return this.from;
    }

    @JsonProperty(value="From")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrom(Address from) {
        this.from = from;
    }

    public Message HTML(String HTML) {
        this.HTML = HTML;
        return this;
    }

    @Nullable
    @JsonProperty(value="HTML")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHTML() {
        return this.HTML;
    }

    @JsonProperty(value="HTML")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHTML(String HTML) {
        this.HTML = HTML;
    }

    public Message ID(String ID) {
        this.ID = ID;
        return this;
    }

    @Nullable
    @JsonProperty(value="ID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getID() {
        return this.ID;
    }

    @JsonProperty(value="ID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setID(String ID) {
        this.ID = ID;
    }

    public Message inline(List<Attachment> inline) {
        this.inline = inline;
        return this;
    }

    public Message addInlineItem(Attachment inlineItem) {
        if (this.inline == null) {
            this.inline = new ArrayList<Attachment>();
        }
        this.inline.add(inlineItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Inline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Attachment> getInline() {
        return this.inline;
    }

    @JsonProperty(value="Inline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInline(List<Attachment> inline) {
        this.inline = inline;
    }

    public Message messageID(String messageID) {
        this.messageID = messageID;
        return this;
    }

    @Nullable
    @JsonProperty(value="MessageID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessageID() {
        return this.messageID;
    }

    @JsonProperty(value="MessageID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public Message replyTo(List<Address> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public Message addReplyToItem(Address replyToItem) {
        if (this.replyTo == null) {
            this.replyTo = new ArrayList<Address>();
        }
        this.replyTo.add(replyToItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="ReplyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Address> getReplyTo() {
        return this.replyTo;
    }

    @JsonProperty(value="ReplyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReplyTo(List<Address> replyTo) {
        this.replyTo = replyTo;
    }

    public Message returnPath(String returnPath) {
        this.returnPath = returnPath;
        return this;
    }

    @Nullable
    @JsonProperty(value="ReturnPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReturnPath() {
        return this.returnPath;
    }

    @JsonProperty(value="ReturnPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public Message size(Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    @JsonProperty(value="Size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSize() {
        return this.size;
    }

    @JsonProperty(value="Size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(Long size) {
        this.size = size;
    }

    public Message subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="Subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="Subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Message tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Message addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="Tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Message text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @JsonProperty(value="Text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="Text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setText(String text) {
        this.text = text;
    }

    public Message to(List<Address> to) {
        this.to = to;
        return this;
    }

    public Message addToItem(Address toItem) {
        if (this.to == null) {
            this.to = new ArrayList<Address>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="To")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Address> getTo() {
        return this.to;
    }

    @JsonProperty(value="To")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTo(List<Address> to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.attachments, message.attachments) && Objects.equals(this.bcc, message.bcc) && Objects.equals(this.cc, message.cc) && Objects.equals(this.date, message.date) && Objects.equals(this.from, message.from) && Objects.equals(this.HTML, message.HTML) && Objects.equals(this.ID, message.ID) && Objects.equals(this.inline, message.inline) && Objects.equals(this.messageID, message.messageID) && Objects.equals(this.replyTo, message.replyTo) && Objects.equals(this.returnPath, message.returnPath) && Objects.equals(this.size, message.size) && Objects.equals(this.subject, message.subject) && Objects.equals(this.tags, message.tags) && Objects.equals(this.text, message.text) && Objects.equals(this.to, message.to);
    }

    public int hashCode() {
        return Objects.hash(this.attachments, this.bcc, this.cc, this.date, this.from, this.HTML, this.ID, this.inline, this.messageID, this.replyTo, this.returnPath, this.size, this.subject, this.tags, this.text, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Message {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    HTML: ").append(this.toIndentedString(this.HTML)).append("\n");
        sb.append("    ID: ").append(this.toIndentedString(this.ID)).append("\n");
        sb.append("    inline: ").append(this.toIndentedString(this.inline)).append("\n");
        sb.append("    messageID: ").append(this.toIndentedString(this.messageID)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    returnPath: ").append(this.toIndentedString(this.returnPath)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAttachments() != null) {
            for (i = 0; i < this.getAttachments().size(); ++i) {
                if (this.getAttachments().get(i) == null) continue;
                joiner.add(this.getAttachments().get(i).toUrlQueryString(String.format("%sAttachments%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getBcc() != null) {
            for (i = 0; i < this.getBcc().size(); ++i) {
                if (this.getBcc().get(i) == null) continue;
                joiner.add(this.getBcc().get(i).toUrlQueryString(String.format("%sBcc%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getCc() != null) {
            for (i = 0; i < this.getCc().size(); ++i) {
                if (this.getCc().get(i) == null) continue;
                joiner.add(this.getCc().get(i).toUrlQueryString(String.format("%sCc%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getDate() != null) {
            joiner.add(String.format("%sDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFrom() != null) {
            joiner.add(this.getFrom().toUrlQueryString((String)prefix + JSON_PROPERTY_FROM + suffix));
        }
        if (this.getHTML() != null) {
            joiner.add(String.format("%sHTML%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getHTML()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getID() != null) {
            joiner.add(String.format("%sID%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getID()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInline() != null) {
            for (i = 0; i < this.getInline().size(); ++i) {
                if (this.getInline().get(i) == null) continue;
                joiner.add(this.getInline().get(i).toUrlQueryString(String.format("%sInline%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMessageID() != null) {
            joiner.add(String.format("%sMessageID%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMessageID()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getReplyTo() != null) {
            for (i = 0; i < this.getReplyTo().size(); ++i) {
                if (this.getReplyTo().get(i) == null) continue;
                joiner.add(this.getReplyTo().get(i).toUrlQueryString(String.format("%sReplyTo%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getReturnPath() != null) {
            joiner.add(String.format("%sReturnPath%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getReturnPath()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSize() != null) {
            joiner.add(String.format("%sSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSubject() != null) {
            joiner.add(String.format("%sSubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSubject()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (i = 0; i < this.getTags().size(); ++i) {
                joiner.add(String.format("%sTags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTags().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getText() != null) {
            joiner.add(String.format("%sText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getText()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTo() != null) {
            for (i = 0; i < this.getTo().size(); ++i) {
                if (this.getTo().get(i) == null) continue;
                joiner.add(this.getTo().get(i).toUrlQueryString(String.format("%sTo%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

