/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.quarkiverse.mailpit.test.invoker.ApiClient;
import io.quarkiverse.mailpit.test.invoker.ApiException;
import io.quarkiverse.mailpit.test.model.AppInformation;
import io.quarkiverse.mailpit.test.model.DeleteRequest;
import io.quarkiverse.mailpit.test.model.Message;
import io.quarkiverse.mailpit.test.model.MessageSummary;
import io.quarkiverse.mailpit.test.model.MessagesSummary;
import io.quarkiverse.mailpit.test.rest.ApplicationApi;
import io.quarkiverse.mailpit.test.rest.MessageApi;
import io.quarkiverse.mailpit.test.rest.MessagesApi;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class Mailbox {
    private ApiClient apiClient;
    private ApplicationApi applicationApi;
    private MessagesApi messagesApi;
    private MessageApi messageApi;

    public void delete(String ID) throws ApiException {
        MessagesApi messagesApi = this.getMessagesApi();
        DeleteRequest request = new DeleteRequest();
        request.addIdsItem(ID);
        messagesApi.delete(request);
    }

    public void clear() throws ApiException {
        MessagesApi messagesApi = this.getMessagesApi();
        DeleteRequest request = new DeleteRequest();
        messagesApi.delete(request);
    }

    public List<Message> find(String query, Integer start, Integer limit) throws ApiException {
        ArrayList<Message> results = new ArrayList<Message>();
        MessagesApi messagesApi = this.getMessagesApi();
        MessageApi messageApi = this.getMessageApi();
        MessagesSummary messages = messagesApi.messagesSummary(query, 0, 50);
        for (MessageSummary summary : messages.getMessages()) {
            Message message = messageApi.message(summary.getID());
            results.add(message);
        }
        return results;
    }

    public Message findFirst(String query) throws ApiException {
        List<Message> results = this.find(query, 0, 1);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public AppInformation getApplicationInfo() throws ApiException {
        ApplicationApi api = this.getApplicationApi();
        return api.appInformation();
    }

    public ApiClient getApiClient() {
        if (this.apiClient == null) {
            this.apiClient = this.createApiClient();
        }
        return this.apiClient;
    }

    public ApplicationApi getApplicationApi() {
        if (this.applicationApi == null) {
            this.applicationApi = new ApplicationApi(this.getApiClient());
        }
        return this.applicationApi;
    }

    public MessagesApi getMessagesApi() {
        if (this.messagesApi == null) {
            this.messagesApi = new MessagesApi(this.getApiClient());
        }
        return this.messagesApi;
    }

    public MessageApi getMessageApi() {
        if (this.messageApi == null) {
            this.messageApi = new MessageApi(this.getApiClient());
        }
        return this.messageApi;
    }

    public ApiClient createApiClient() {
        HttpClient.Builder httpClient = HttpClient.newBuilder();
        ApiClient client = new ApiClient();
        client.setHttpClientBuilder(httpClient);
        client.setObjectMapper(this.createDefaultObjectMapper());
        client.updateBaseUri(this.getMailApiUrl());
        client.setConnectTimeout(Duration.ofSeconds(5L));
        client.setReadTimeout(Duration.ofSeconds(30L));
        return client;
    }

    public String getMailApiUrl() {
        Optional mailPort = ConfigProvider.getConfig().getOptionalValue("mailpit.http.server", String.class);
        return (String)mailPort.orElseThrow(() -> new IllegalStateException("Mailer cannot find `mailpit.http.server` so it cannot be used in testing."));
    }

    public ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        JavaTimeModule module = new JavaTimeModule();
        mapper.registerModule((Module)module);
        return mapper;
    }
}

