/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Message Relay information
 */
@JsonPropertyOrder({
  WebUIConfigurationMessageRelay.JSON_PROPERTY_ENABLED,
  WebUIConfigurationMessageRelay.JSON_PROPERTY_RECIPIENT_ALLOWLIST,
  WebUIConfigurationMessageRelay.JSON_PROPERTY_RETURN_PATH,
  WebUIConfigurationMessageRelay.JSON_PROPERTY_SM_T_P_SERVER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WebUIConfigurationMessageRelay {
  public static final String JSON_PROPERTY_ENABLED = "Enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_RECIPIENT_ALLOWLIST = "RecipientAllowlist";
  private String recipientAllowlist;

  public static final String JSON_PROPERTY_RETURN_PATH = "ReturnPath";
  private String returnPath;

  public static final String JSON_PROPERTY_SM_T_P_SERVER = "SMTPServer";
  private String smTPServer;

  public WebUIConfigurationMessageRelay() { 
  }

  public WebUIConfigurationMessageRelay enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether message relaying (release) is enabled
   * @return enabled
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public WebUIConfigurationMessageRelay recipientAllowlist(String recipientAllowlist) {
    this.recipientAllowlist = recipientAllowlist;
    return this;
  }

   /**
   * Allowlist of accepted recipients
   * @return recipientAllowlist
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ALLOWLIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecipientAllowlist() {
    return recipientAllowlist;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT_ALLOWLIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecipientAllowlist(String recipientAllowlist) {
    this.recipientAllowlist = recipientAllowlist;
  }


  public WebUIConfigurationMessageRelay returnPath(String returnPath) {
    this.returnPath = returnPath;
    return this;
  }

   /**
   * Enforced Return-Path (if set) for relay bounces
   * @return returnPath
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RETURN_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnPath() {
    return returnPath;
  }


  @JsonProperty(JSON_PROPERTY_RETURN_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReturnPath(String returnPath) {
    this.returnPath = returnPath;
  }


  public WebUIConfigurationMessageRelay smTPServer(String smTPServer) {
    this.smTPServer = smTPServer;
    return this;
  }

   /**
   * The configured SMTP server address
   * @return smTPServer
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SM_T_P_SERVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSmTPServer() {
    return smTPServer;
  }


  @JsonProperty(JSON_PROPERTY_SM_T_P_SERVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmTPServer(String smTPServer) {
    this.smTPServer = smTPServer;
  }


  /**
   * Return true if this WebUIConfiguration_MessageRelay object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebUIConfigurationMessageRelay webUIConfigurationMessageRelay = (WebUIConfigurationMessageRelay) o;
    return Objects.equals(this.enabled, webUIConfigurationMessageRelay.enabled) &&
        Objects.equals(this.recipientAllowlist, webUIConfigurationMessageRelay.recipientAllowlist) &&
        Objects.equals(this.returnPath, webUIConfigurationMessageRelay.returnPath) &&
        Objects.equals(this.smTPServer, webUIConfigurationMessageRelay.smTPServer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, recipientAllowlist, returnPath, smTPServer);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebUIConfigurationMessageRelay {\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    recipientAllowlist: ").append(toIndentedString(recipientAllowlist)).append("\n");
    sb.append("    returnPath: ").append(toIndentedString(returnPath)).append("\n");
    sb.append("    smTPServer: ").append(toIndentedString(smTPServer)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `Enabled` to the URL query string
    if (getEnabled() != null) {
      joiner.add(String.format("%sEnabled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEnabled()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `RecipientAllowlist` to the URL query string
    if (getRecipientAllowlist() != null) {
      joiner.add(String.format("%sRecipientAllowlist%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRecipientAllowlist()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ReturnPath` to the URL query string
    if (getReturnPath() != null) {
      joiner.add(String.format("%sReturnPath%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReturnPath()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `SMTPServer` to the URL query string
    if (getSmTPServer() != null) {
      joiner.add(String.format("%sSMTPServer%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSmTPServer()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

