/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"Address", "Name"})
public class Address {
    public static final String JSON_PROPERTY_ADDRESS = "Address";
    private String address;
    public static final String JSON_PROPERTY_NAME = "Name";
    private String name;

    public Address address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @JsonProperty(value="Address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="Address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public Address name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="Name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="Name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.address, address.address) && Objects.equals(this.name, address.name);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAddress() != null) {
            joiner.add(String.format("%sAddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

