/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkiverse.mailpit.test.model.MessageSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * MessagesSummary is a summary of a list of messages
 */
@JsonPropertyOrder({
  MessagesSummary.JSON_PROPERTY_MESSAGES,
  MessagesSummary.JSON_PROPERTY_MESSAGES_COUNT,
  MessagesSummary.JSON_PROPERTY_START,
  MessagesSummary.JSON_PROPERTY_TAGS,
  MessagesSummary.JSON_PROPERTY_TOTAL,
  MessagesSummary.JSON_PROPERTY_UNREAD
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class MessagesSummary {
  public static final String JSON_PROPERTY_MESSAGES = "messages";
  private List<MessageSummary> messages;

  public static final String JSON_PROPERTY_MESSAGES_COUNT = "messages_count";
  private Long messagesCount;

  public static final String JSON_PROPERTY_START = "start";
  private Long start;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<String> tags;

  public static final String JSON_PROPERTY_TOTAL = "total";
  private Long total;

  public static final String JSON_PROPERTY_UNREAD = "unread";
  private Long unread;

  public MessagesSummary() { 
  }

  public MessagesSummary messages(List<MessageSummary> messages) {
    this.messages = messages;
    return this;
  }

  public MessagesSummary addMessagesItem(MessageSummary messagesItem) {
    if (this.messages == null) {
      this.messages = new ArrayList<>();
    }
    this.messages.add(messagesItem);
    return this;
  }

   /**
   * Messages summary in:body
   * @return messages
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MessageSummary> getMessages() {
    return messages;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessages(List<MessageSummary> messages) {
    this.messages = messages;
  }


  public MessagesSummary messagesCount(Long messagesCount) {
    this.messagesCount = messagesCount;
    return this;
  }

   /**
   * Total number of messages matching current query
   * @return messagesCount
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGES_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMessagesCount() {
    return messagesCount;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessagesCount(Long messagesCount) {
    this.messagesCount = messagesCount;
  }


  public MessagesSummary start(Long start) {
    this.start = start;
    return this;
  }

   /**
   * Pagination offset
   * @return start
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getStart() {
    return start;
  }


  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStart(Long start) {
    this.start = start;
  }


  public MessagesSummary tags(List<String> tags) {
    this.tags = tags;
    return this;
  }

  public MessagesSummary addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * All current tags
   * @return tags
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  public MessagesSummary total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * Total number of messages in mailbox
   * @return total
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(Long total) {
    this.total = total;
  }


  public MessagesSummary unread(Long unread) {
    this.unread = unread;
    return this;
  }

   /**
   * Total number of unread messages in mailbox
   * @return unread
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNREAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUnread() {
    return unread;
  }


  @JsonProperty(JSON_PROPERTY_UNREAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnread(Long unread) {
    this.unread = unread;
  }


  /**
   * Return true if this MessagesSummary object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessagesSummary messagesSummary = (MessagesSummary) o;
    return Objects.equals(this.messages, messagesSummary.messages) &&
        Objects.equals(this.messagesCount, messagesSummary.messagesCount) &&
        Objects.equals(this.start, messagesSummary.start) &&
        Objects.equals(this.tags, messagesSummary.tags) &&
        Objects.equals(this.total, messagesSummary.total) &&
        Objects.equals(this.unread, messagesSummary.unread);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messages, messagesCount, start, tags, total, unread);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessagesSummary {\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    messagesCount: ").append(toIndentedString(messagesCount)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    unread: ").append(toIndentedString(unread)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `messages` to the URL query string
    if (getMessages() != null) {
      for (int i = 0; i < getMessages().size(); i++) {
        if (getMessages().get(i) != null) {
          joiner.add(getMessages().get(i).toUrlQueryString(String.format("%smessages%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `messages_count` to the URL query string
    if (getMessagesCount() != null) {
      joiner.add(String.format("%smessages_count%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessagesCount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `start` to the URL query string
    if (getStart() != null) {
      joiner.add(String.format("%sstart%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStart()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      for (int i = 0; i < getTags().size(); i++) {
        joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getTags().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `total` to the URL query string
    if (getTotal() != null) {
      joiner.add(String.format("%stotal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTotal()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `unread` to the URL query string
    if (getUnread() != null) {
      joiner.add(String.format("%sunread%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnread()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

