/*
 * Mailpit API
 * OpenAPI 2.0 documentation for [Mailpit](https://github.com/axllent/mailpit).
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.quarkiverse.mailpit.test.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Attachment struct for inline and attachments
 */
@JsonPropertyOrder({
  Attachment.JSON_PROPERTY_CONTENT_I_D,
  Attachment.JSON_PROPERTY_CONTENT_TYPE,
  Attachment.JSON_PROPERTY_FILE_NAME,
  Attachment.JSON_PROPERTY_PART_I_D,
  Attachment.JSON_PROPERTY_SIZE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Attachment {
  public static final String JSON_PROPERTY_CONTENT_I_D = "ContentID";
  private String contentID;

  public static final String JSON_PROPERTY_CONTENT_TYPE = "ContentType";
  private String contentType;

  public static final String JSON_PROPERTY_FILE_NAME = "FileName";
  private String fileName;

  public static final String JSON_PROPERTY_PART_I_D = "PartID";
  private String partID;

  public static final String JSON_PROPERTY_SIZE = "Size";
  private Long size;

  public Attachment() { 
  }

  public Attachment contentID(String contentID) {
    this.contentID = contentID;
    return this;
  }

   /**
   * Content ID
   * @return contentID
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTENT_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContentID() {
    return contentID;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentID(String contentID) {
    this.contentID = contentID;
  }


  public Attachment contentType(String contentType) {
    this.contentType = contentType;
    return this;
  }

   /**
   * Content type
   * @return contentType
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContentType() {
    return contentType;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentType(String contentType) {
    this.contentType = contentType;
  }


  public Attachment fileName(String fileName) {
    this.fileName = fileName;
    return this;
  }

   /**
   * File name
   * @return fileName
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileName() {
    return fileName;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


  public Attachment partID(String partID) {
    this.partID = partID;
    return this;
  }

   /**
   * Attachment part ID
   * @return partID
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PART_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPartID() {
    return partID;
  }


  @JsonProperty(JSON_PROPERTY_PART_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartID(String partID) {
    this.partID = partID;
  }


  public Attachment size(Long size) {
    this.size = size;
    return this;
  }

   /**
   * Size in bytes
   * @return size
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSize(Long size) {
    this.size = size;
  }


  /**
   * Return true if this Attachment object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Attachment attachment = (Attachment) o;
    return Objects.equals(this.contentID, attachment.contentID) &&
        Objects.equals(this.contentType, attachment.contentType) &&
        Objects.equals(this.fileName, attachment.fileName) &&
        Objects.equals(this.partID, attachment.partID) &&
        Objects.equals(this.size, attachment.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contentID, contentType, fileName, partID, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Attachment {\n");
    sb.append("    contentID: ").append(toIndentedString(contentID)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("    partID: ").append(toIndentedString(partID)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `ContentID` to the URL query string
    if (getContentID() != null) {
      joiner.add(String.format("%sContentID%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContentID()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ContentType` to the URL query string
    if (getContentType() != null) {
      joiner.add(String.format("%sContentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContentType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `FileName` to the URL query string
    if (getFileName() != null) {
      joiner.add(String.format("%sFileName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFileName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `PartID` to the URL query string
    if (getPartID() != null) {
      joiner.add(String.format("%sPartID%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPartID()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `Size` to the URL query string
    if (getSize() != null) {
      joiner.add(String.format("%sSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

