/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.deployment.devui;

import io.quarkiverse.mailpit.deployment.MailpitDevServicesConfigBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.Map;
import java.util.Optional;

public class MailpitDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    void createVersion(BuildProducer<CardPageBuildItem> cardPageBuildItemBuildProducer, Optional<MailpitDevServicesConfigBuildItem> configProps, BuildProducer<FooterPageBuildItem> footerProducer) {
        if (configProps.isPresent()) {
            Map<String, String> config = configProps.get().getConfig();
            CardPageBuildItem card = new CardPageBuildItem();
            if (config.containsKey("mailpit.smtp.port")) {
                PageBuilder versionPage = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"SMTP Port").icon("font-awesome-solid:envelope")).doNotEmbed().url("https://github.com/axllent/mailpit").staticLabel(config.getOrDefault("mailpit.smtp.port", "0"));
                card.addPage(versionPage);
            }
            if (config.containsKey("mailpit.http.server")) {
                String uiPath = config.get("mailpit.http.server");
                card.addPage((PageBuilder)Page.externalPageBuilder((String)"Mailpit UI").url(uiPath, uiPath).isHtmlContent().icon("font-awesome-solid:envelopes-bulk"));
            }
            card.setCustomCard("qwc-mailpit-card.js");
            cardPageBuildItemBuildProducer.produce((BuildItem)card);
            WebComponentPageBuilder mailLogPageBuilder = ((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:envelope")).title("Mailer")).componentLink("qwc-mailpit-log.js");
            footerProducer.produce((BuildItem)new FooterPageBuildItem(new PageBuilder[]{mailLogPageBuilder}));
        }
    }
}

