/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.deployment;

import io.quarkiverse.mailpit.deployment.MailpitConfig;
import io.quarkiverse.mailpit.deployment.MailpitContainer;
import io.quarkiverse.mailpit.deployment.MailpitDevServicesConfigBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class MailpitProcessor {
    private static final Logger log = Logger.getLogger(MailpitProcessor.class);
    public static final String FEATURE = "mailpit";
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-mailpit";
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile MailpitConfig cfg;
    static volatile boolean first;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public DevServicesResultBuildItem startMailpitDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, MailpitConfig mailpitConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, BuildProducer<MailpitDevServicesConfigBuildItem> mailpitBuildItemBuildProducer, CombinedIndexBuildItem combinedIndexBuildItem) {
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !MailpitConfig.isEqual(cfg, mailpitConfig);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.shutdown();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Mailpit Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startMailpit(dockerStatusBuildItem, mailpitConfig, devServicesConfig, !devServicesSharedNetworkBuildItem.isEmpty(), combinedIndexBuildItem.getIndex());
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (devService.isOwner()) {
            log.info((Object)"Dev Services for Mailpit started.");
            mailpitBuildItemBuildProducer.produce((BuildItem)new MailpitDevServicesConfigBuildItem(devService.getConfig()));
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdown();
                    log.info((Object)"Dev Services for Mailpit shut down.");
                }
                first = true;
                devService = null;
                cfg = null;
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        cfg = mailpitConfig;
        return devService.toBuildItem();
    }

    private DevServicesResultBuildItem.RunningDevService startMailpit(DockerStatusBuildItem dockerStatusBuildItem, MailpitConfig mailpitConfig, GlobalDevServicesConfig devServicesConfig, boolean useSharedNetwork, IndexView index) {
        if (!mailpitConfig.enabled()) {
            log.warn((Object)"Not starting dev services for Mailpit, as it has been disabled in the config.");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Docker isn't working, not starting dev services for Mailpit.");
            return null;
        }
        MailpitContainer mailpit = new MailpitContainer(mailpitConfig, useSharedNetwork, index);
        devServicesConfig.timeout.ifPresent(arg_0 -> ((MailpitContainer)mailpit).withStartupTimeout(arg_0));
        mailpit.start();
        return new DevServicesResultBuildItem.RunningDevService(FEATURE, mailpit.getContainerId(), () -> ((MailpitContainer)mailpit).close(), mailpit.getExposedConfig());
    }

    private void shutdown() {
        if (devService != null) {
            try {
                log.info((Object)"Dev Services for Mailpit shutting down...");
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Mailpit server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    static {
        first = true;
    }
}

