/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.deployment;

import io.quarkiverse.mailpit.deployment.JbossContainerLogConsumer;
import io.quarkiverse.mailpit.deployment.MailpitConfig;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.mailer.MailerName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public final class MailpitContainer
extends GenericContainer<MailpitContainer> {
    public static final String CONFIG_SMTP_PORT = "mailpit.smtp.port";
    public static final String CONFIG_HTTP_SERVER = "mailpit.http.server";
    private static final Logger log = Logger.getLogger(MailpitContainer.class);
    private static final Integer PORT_SMTP = 1025;
    private static final Integer PORT_HTTP = 8025;
    private final boolean useSharedNetwork;
    private String hostName;
    private IndexView index;

    MailpitContainer(MailpitConfig config, boolean useSharedNetwork, IndexView index) {
        super(DockerImageName.parse((String)config.imageName()).asCompatibleSubstituteFor("axllent/mailpit"));
        this.useSharedNetwork = useSharedNetwork;
        this.index = index;
        super.withLabel("quarkus-dev-service-mailpit", "mailpit");
        super.withNetwork(Network.SHARED);
        super.waitingFor((WaitStrategy)Wait.forHttp((String)"/").forPort(PORT_HTTP.intValue()));
        if (config.verbose()) {
            super.withEnv("MP_VERBOSE", "true");
        }
        super.withLogConsumer((Consumer)((Object)new JbossContainerLogConsumer(log).withPrefix("mailpit")));
    }

    protected void configure() {
        super.configure();
        if (this.useSharedNetwork) {
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mailpit");
            return;
        }
        this.addExposedPorts(new int[]{PORT_SMTP, PORT_HTTP});
    }

    public Map<String, String> getExposedConfig() {
        HashMap<String, String> exposed = new HashMap<String, String>();
        String port = Objects.toString(this.getMappedPort(PORT_SMTP));
        exposed.put(CONFIG_SMTP_PORT, port);
        exposed.put(CONFIG_HTTP_SERVER, this.getMailpitHttpServer());
        exposed.putAll(super.getEnvMap());
        exposed.put("quarkus.mailer.port", port);
        exposed.put("quarkus.mailer.host", this.getHost());
        exposed.put("quarkus.mailer.mock", "false");
        Collection namedMailers = this.index.getAnnotations(MailerName.class.getName());
        for (AnnotationInstance namedMailer : namedMailers) {
            String name = namedMailer.value().asString();
            exposed.put("quarkus.mailer." + name + ".port", port);
            exposed.put("quarkus.mailer." + name + ".host", this.getHost());
            exposed.put("quarkus.mailer." + name + ".mock", "false");
        }
        return exposed;
    }

    public String getMailpitHttpServer() {
        return String.format("http://%s:%d", this.getHost(), this.getMappedPort(PORT_HTTP));
    }
}

