/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.lucene.runtime;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkiverse.lucene.runtime.AttributeCreator;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;

@TargetClass(value=AttributeFactory.class)
public final class AttributeFactoryReplacement {
    @Substitute
    public static <A extends AttributeImpl> AttributeFactory getStaticImplementation(AttributeFactory delegate, final Class<A> clazz) {
        return new AttributeFactory.StaticImplementationAttributeFactory<A>(delegate, clazz){

            protected A createInstance() {
                try {
                    return AttributeCreator.create(clazz);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        };
    }
}

