/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.lucene.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.AbstractAnalysisFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.store.BaseDirectory;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.tartarus.snowball.SnowballProgram;

class LuceneProcessor {
    private static final String FEATURE = "lucene";

    LuceneProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("org.apache.lucene", "lucene-core"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.apache.lucene", "lucene-analysis-common"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.apache.lucene", "lucene-queryparser"));
    }

    @BuildStep
    void commonTokenizerReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        HashSet<String> classNames = new HashSet<String>();
        classNames.addAll(this.collectSubclasses(combinedIndex, TokenizerFactory.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, TokenFilterFactory.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, SnowballProgram.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, AbstractAnalysisFactory.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, BaseDirectory.class.getName()));
        classNames.add(MemoryIndex.class.getName());
        this.addCtorReflection(reflectiveClass, classNames);
    }

    @BuildStep
    void runtimeClasses(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("org.apache.lucene.document.InetAddressPoint"));
    }

    private void addCtorReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Set<String> classNames) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).constructors(true).build());
    }

    private List<String> collectSubclasses(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        return classes;
    }
}

