/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.lucene.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.store.BaseDirectory;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.tartarus.snowball.SnowballProgram;

class LuceneProcessor {
    private static final String FEATURE = "lucene";

    LuceneProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("org.apache.lucene", "lucene-core"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.apache.lucene", "lucene-analyzers-common"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.apache.lucene", "lucene-queryparser"));
    }

    @BuildStep
    void commonTokenizerReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        HashSet<String> classNames = new HashSet<String>();
        classNames.addAll(this.collectSubclasses(combinedIndex, TokenizerFactory.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, TokenFilterFactory.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, SnowballProgram.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, AbstractAnalysisFactory.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, BaseDirectory.class.getName()));
        classNames.add(MemoryIndex.class.getName());
        this.addCtorReflection(reflectiveClass, classNames);
    }

    private void addCtorReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Set<String> classNames) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, classNames.toArray(new String[0])));
    }

    private List<String> collectSubclasses(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        return classes;
    }

    private List<String> collectImplementors(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownImplementors(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        return classes;
    }
}

