/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import dev.langchain4j.model.output.Response;
import io.quarkiverse.langchain4j.watsonx.WatsonxModel;
import io.quarkiverse.langchain4j.watsonx.bean.EmbeddingRequest;
import io.quarkiverse.langchain4j.watsonx.bean.EmbeddingResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TokenizationRequest;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class WatsonxEmbeddingModel
extends WatsonxModel
implements EmbeddingModel,
TokenCountEstimator {
    public WatsonxEmbeddingModel(WatsonxModel.Builder config) {
        super(config);
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        if (Objects.isNull(textSegments) || textSegments.isEmpty()) {
            return Response.from(List.of());
        }
        List<String> inputs = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        final EmbeddingRequest request = new EmbeddingRequest(this.modelId, this.projectId, inputs);
        EmbeddingResponse result = WatsonxEmbeddingModel.retryOn(new Callable<EmbeddingResponse>(){

            @Override
            public EmbeddingResponse call() throws Exception {
                String token = (String)WatsonxEmbeddingModel.this.generateBearerToken().await().atMost(Duration.ofSeconds(10L));
                return WatsonxEmbeddingModel.this.client.embeddings(request, token, WatsonxEmbeddingModel.this.version);
            }
        });
        return Response.from(result.results().stream().map(EmbeddingResponse.Result::embedding).map(Embedding::from).collect(Collectors.toList()));
    }

    public int estimateTokenCount(String text) {
        if (Objects.isNull(text) || text.isEmpty()) {
            return 0;
        }
        final TokenizationRequest request = new TokenizationRequest(this.modelId, text, this.projectId);
        return WatsonxEmbeddingModel.retryOn(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                String token = (String)WatsonxEmbeddingModel.this.generateBearerToken().await().atMost(Duration.ofSeconds(10L));
                return WatsonxEmbeddingModel.this.client.tokenization(request, token, WatsonxEmbeddingModel.this.version).result().tokenCount();
            }
        });
    }
}

