/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.chat.DisabledStreamingChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkiverse.langchain4j.watsonx.TokenGenerator;
import io.quarkiverse.langchain4j.watsonx.WatsonxChatModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxEmbeddingModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxStreamingChatModel;
import io.quarkiverse.langchain4j.watsonx.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.IAMConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.LangChain4jWatsonxConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class WatsonxRecorder {
    private static final String DUMMY_URL = "https://dummy.ai/api";
    private static final String DUMMY_API_KEY = "dummy";
    private static final String DUMMY_PROJECT_ID = "dummy";
    private static final Map<String, TokenGenerator> tokenGeneratorCache = new HashMap<String, TokenGenerator>();
    private static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];

    public Supplier<ChatLanguageModel> chatModel(LangChain4jWatsonxConfig runtimeConfig, String modelName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonConfig(runtimeConfig, modelName);
        if (watsonConfig.enableIntegration().booleanValue()) {
            final WatsonxModel.Builder builder = this.generateChatBuilder(watsonConfig, modelName);
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build(WatsonxChatModel.class);
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    public Supplier<StreamingChatLanguageModel> streamingChatModel(LangChain4jWatsonxConfig runtimeConfig, String modelName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonConfig(runtimeConfig, modelName);
        if (watsonConfig.enableIntegration().booleanValue()) {
            final WatsonxModel.Builder builder = this.generateChatBuilder(watsonConfig, modelName);
            return new Supplier<StreamingChatLanguageModel>(){

                @Override
                public StreamingChatLanguageModel get() {
                    return builder.build(WatsonxStreamingChatModel.class);
                }
            };
        }
        return new Supplier<StreamingChatLanguageModel>(){

            @Override
            public StreamingChatLanguageModel get() {
                return new DisabledStreamingChatLanguageModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(LangChain4jWatsonxConfig runtimeConfig, String modelName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonConfig(runtimeConfig, modelName);
        if (watsonConfig.enableIntegration().booleanValue()) {
            URL url;
            List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(watsonConfig, modelName);
            if (!configProblems.isEmpty()) {
                throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
            }
            String iamUrl = watsonConfig.iam().baseUrl().toExternalForm();
            TokenGenerator tokenGenerator = tokenGeneratorCache.computeIfAbsent(iamUrl, this.createTokenGenerator(watsonConfig.iam(), watsonConfig.apiKey()));
            try {
                url = new URL(watsonConfig.baseUrl());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            EmbeddingModelConfig embeddingModelConfig = watsonConfig.embeddingModel();
            final WatsonxModel.Builder builder = WatsonxEmbeddingModel.builder().tokenGenerator(tokenGenerator).url(url).timeout(watsonConfig.timeout()).logRequests(embeddingModelConfig.logRequests().orElse(false)).logResponses(embeddingModelConfig.logResponses().orElse(false)).version(watsonConfig.version()).projectId(watsonConfig.projectId()).modelId(embeddingModelConfig.modelId());
            return new Supplier<EmbeddingModel>(){

                @Override
                public WatsonxEmbeddingModel get() {
                    return builder.build(WatsonxEmbeddingModel.class);
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    private Function<? super String, ? extends TokenGenerator> createTokenGenerator(final IAMConfig iamConfig, final String apiKey) {
        return new Function<String, TokenGenerator>(){

            @Override
            public TokenGenerator apply(String iamUrl) {
                return new TokenGenerator(iamConfig.baseUrl(), iamConfig.timeout(), iamConfig.grantType(), apiKey);
            }
        };
    }

    private WatsonxModel.Builder generateChatBuilder(LangChain4jWatsonxConfig.WatsonConfig watsonConfig, String modelName) {
        URL url;
        ChatModelConfig chatModelConfig = watsonConfig.chatModel();
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(watsonConfig, modelName);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        String iamUrl = watsonConfig.iam().baseUrl().toExternalForm();
        TokenGenerator tokenGenerator = tokenGeneratorCache.computeIfAbsent(iamUrl, this.createTokenGenerator(watsonConfig.iam(), watsonConfig.apiKey()));
        try {
            url = new URL(watsonConfig.baseUrl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Double decayFactor = null;
        Integer startIndex = null;
        if (chatModelConfig.lengthPenalty().isPresent()) {
            decayFactor = chatModelConfig.lengthPenalty().map(ChatModelConfig.LengthPenaltyConfig::decayFactor).get().orElse(null);
            startIndex = chatModelConfig.lengthPenalty().map(ChatModelConfig.LengthPenaltyConfig::startIndex).get().orElse(null);
        }
        return WatsonxChatModel.builder().tokenGenerator(tokenGenerator).url(url).timeout(watsonConfig.timeout()).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false)).version(watsonConfig.version()).projectId(watsonConfig.projectId()).modelId(chatModelConfig.modelId()).decodingMethod(chatModelConfig.decodingMethod()).decayFactor(decayFactor).startIndex(startIndex).maxNewTokens(chatModelConfig.maxNewTokens()).minNewTokens(chatModelConfig.minNewTokens()).temperature(chatModelConfig.temperature()).randomSeed((Integer)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.randomSeed()})).stopSequences((List)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.stopSequences()})).topK((Integer)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.topK()})).topP((Double)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.topP()})).repetitionPenalty((Double)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.repetitionPenalty()})).truncateInputTokens(chatModelConfig.truncateInputTokens().orElse(null)).includeStopSequence(chatModelConfig.includeStopSequence().orElse(null));
    }

    private LangChain4jWatsonxConfig.WatsonConfig correspondingWatsonConfig(LangChain4jWatsonxConfig runtimeConfig, String modelName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = NamedModelUtil.isDefault((String)modelName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(modelName);
        return watsonConfig;
    }

    private List<ConfigValidationException.Problem> checkConfigurations(LangChain4jWatsonxConfig.WatsonConfig watsonConfig, String modelName) {
        String projectId;
        String apiKey;
        ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
        if (DUMMY_URL.equals(watsonConfig.baseUrl())) {
            configProblems.add(this.createBaseURLConfigProblem(modelName));
        }
        if ("dummy".equals(apiKey = watsonConfig.apiKey())) {
            configProblems.add(this.createApiKeyConfigProblem(modelName));
        }
        if ("dummy".equals(projectId = watsonConfig.projectId())) {
            configProblems.add(this.createProjectIdProblem(modelName));
        }
        return configProblems;
    }

    private ConfigValidationException.Problem createBaseURLConfigProblem(String modelName) {
        return WatsonxRecorder.createConfigProblem("base-url", modelName);
    }

    private ConfigValidationException.Problem createApiKeyConfigProblem(String modelName) {
        return WatsonxRecorder.createConfigProblem("api-key", modelName);
    }

    private ConfigValidationException.Problem createProjectIdProblem(String modelName) {
        return WatsonxRecorder.createConfigProblem("project-id", modelName);
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String modelName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.watsonx%s%s is required but it could not be found in any config source", NamedModelUtil.isDefault((String)modelName) ? "." : "." + modelName + ".", key));
    }
}

