/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.chat.DisabledStreamingChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkiverse.langchain4j.watsonx.TokenGenerator;
import io.quarkiverse.langchain4j.watsonx.WatsonxChatModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxStreamingChatModel;
import io.quarkiverse.langchain4j.watsonx.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.IAMConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.LangChain4jWatsonxConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class WatsonxRecorder {
    private static final String DUMMY_URL = "https://dummy.ai/api";
    private static final String DUMMY_API_KEY = "dummy";
    private static final String DUMMY_PROJECT_ID = "dummy";
    public static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];

    public Supplier<ChatLanguageModel> chatModel(LangChain4jWatsonxConfig runtimeConfig, String modelName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonConfig(runtimeConfig, modelName);
        if (watsonConfig.enableIntegration().booleanValue()) {
            String projectId;
            String apiKey;
            ChatModelConfig chatModelConfig = watsonConfig.chatModel();
            ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
            URL baseUrl = watsonConfig.baseUrl();
            if (DUMMY_URL.equals(baseUrl.toString())) {
                configProblems.add(this.createBaseURLConfigProblem(modelName));
            }
            if ("dummy".equals(apiKey = watsonConfig.apiKey())) {
                configProblems.add(this.createApiKeyConfigProblem(modelName));
            }
            if ("dummy".equals(projectId = watsonConfig.projectId())) {
                configProblems.add(this.createProjectIdProblem(modelName));
            }
            if (!configProblems.isEmpty()) {
                throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
            }
            IAMConfig iamConfig = watsonConfig.iam();
            TokenGenerator tokenGenerator = new TokenGenerator(iamConfig.baseUrl(), iamConfig.timeout(), iamConfig.grantType(), watsonConfig.apiKey());
            final WatsonxModel.Builder builder = WatsonxChatModel.builder().tokenGenerator(tokenGenerator).url(baseUrl).timeout(watsonConfig.timeout()).logRequests(watsonConfig.logRequests()).logResponses(watsonConfig.logResponses()).version(watsonConfig.version()).projectId(projectId).modelId(chatModelConfig.modelId()).decodingMethod(chatModelConfig.decodingMethod()).minNewTokens(chatModelConfig.minNewTokens()).maxNewTokens(chatModelConfig.maxNewTokens()).temperature(chatModelConfig.temperature()).randomSeed((Integer)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.randomSeed()})).stopSequences((List)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.stopSequences()})).topK((Integer)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.topK()})).topP((Double)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.topP()})).repetitionPenalty((Double)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.repetitionPenalty()}));
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build(WatsonxChatModel.class);
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    public Supplier<StreamingChatLanguageModel> streamingChatModel(LangChain4jWatsonxConfig runtimeConfig, String modelName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonConfig(runtimeConfig, modelName);
        if (watsonConfig.enableIntegration().booleanValue()) {
            String projectId;
            String apiKey;
            ChatModelConfig chatModelConfig = watsonConfig.chatModel();
            ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
            URL baseUrl = watsonConfig.baseUrl();
            if (DUMMY_URL.equals(baseUrl.toString())) {
                configProblems.add(this.createBaseURLConfigProblem(modelName));
            }
            if ("dummy".equals(apiKey = watsonConfig.apiKey())) {
                configProblems.add(this.createApiKeyConfigProblem(modelName));
            }
            if ("dummy".equals(projectId = watsonConfig.projectId())) {
                configProblems.add(this.createProjectIdProblem(modelName));
            }
            if (!configProblems.isEmpty()) {
                throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
            }
            IAMConfig iamConfig = watsonConfig.iam();
            TokenGenerator tokenGenerator = new TokenGenerator(iamConfig.baseUrl(), iamConfig.timeout(), iamConfig.grantType(), watsonConfig.apiKey());
            final WatsonxModel.Builder builder = WatsonxStreamingChatModel.builder().tokenGenerator(tokenGenerator).url(baseUrl).timeout(watsonConfig.timeout()).logRequests(watsonConfig.logRequests()).logResponses(watsonConfig.logResponses()).version(watsonConfig.version()).projectId(projectId).modelId(chatModelConfig.modelId()).decodingMethod(chatModelConfig.decodingMethod()).minNewTokens(chatModelConfig.minNewTokens()).maxNewTokens(chatModelConfig.maxNewTokens()).temperature(chatModelConfig.temperature()).randomSeed((Integer)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.randomSeed()})).stopSequences((List)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.stopSequences()})).topK((Integer)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.topK()})).topP((Double)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.topP()})).repetitionPenalty((Double)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{chatModelConfig.repetitionPenalty()}));
            return new Supplier<StreamingChatLanguageModel>(){

                @Override
                public StreamingChatLanguageModel get() {
                    return builder.build(WatsonxStreamingChatModel.class);
                }
            };
        }
        return new Supplier<StreamingChatLanguageModel>(){

            @Override
            public StreamingChatLanguageModel get() {
                return new DisabledStreamingChatLanguageModel();
            }
        };
    }

    private LangChain4jWatsonxConfig.WatsonConfig correspondingWatsonConfig(LangChain4jWatsonxConfig runtimeConfig, String modelName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = NamedModelUtil.isDefault((String)modelName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(modelName);
        return watsonConfig;
    }

    private ConfigValidationException.Problem createBaseURLConfigProblem(String modelName) {
        return WatsonxRecorder.createConfigProblem("base-url", modelName);
    }

    private ConfigValidationException.Problem createApiKeyConfigProblem(String modelName) {
        return WatsonxRecorder.createConfigProblem("api-key", modelName);
    }

    private ConfigValidationException.Problem createProjectIdProblem(String modelName) {
        return WatsonxRecorder.createConfigProblem("project-id", modelName);
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String modelName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.watsonx%s%s is required but it could not be found in any config source", NamedModelUtil.isDefault((String)modelName) ? "." : "." + modelName + ".", key));
    }
}

