/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.watsonx.WatsonxModel;
import io.quarkiverse.langchain4j.watsonx.bean.Parameters;
import io.quarkiverse.langchain4j.watsonx.bean.TextGenerationRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TextGenerationResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TokenizationRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class WatsonxChatModel
extends WatsonxModel
implements ChatLanguageModel,
TokenCountEstimator {
    public WatsonxChatModel(WatsonxModel.Builder config) {
        super(config);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        Parameters parameters = Parameters.builder().decodingMethod(this.decodingMethod).minNewTokens(this.minNewTokens).maxNewTokens(this.maxNewTokens).randomSeed(this.randomSeed).stopSequences(this.stopSequences).temperature(this.temperature).topP(this.topP).topK(this.topK).repetitionPenalty(this.repetitionPenalty).build();
        final TextGenerationRequest request = new TextGenerationRequest(this.modelId, this.projectId, this.toInput(messages), parameters);
        TextGenerationResponse.Result result = WatsonxChatModel.retryOn(new Callable<TextGenerationResponse>(){

            @Override
            public TextGenerationResponse call() throws Exception {
                String token = (String)WatsonxChatModel.this.generateBearerToken().await().atMost(Duration.ofSeconds(10L));
                return WatsonxChatModel.this.client.chat(request, token, WatsonxChatModel.this.version);
            }
        }).results().get(0);
        FinishReason finishReason = this.toFinishReason(result.stopReason());
        AiMessage content = AiMessage.from((String)result.generatedText());
        TokenUsage tokenUsage = new TokenUsage(Integer.valueOf(result.inputTokenCount()), Integer.valueOf(result.generatedTokenCount()));
        return Response.from((Object)content, (TokenUsage)tokenUsage, (FinishReason)finishReason);
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        String input = messages.stream().map(ChatMessage::text).collect(Collectors.joining(" "));
        final TokenizationRequest request = new TokenizationRequest(this.modelId, input, this.projectId);
        return WatsonxChatModel.retryOn(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                String token = (String)WatsonxChatModel.this.generateBearerToken().await().atMost(Duration.ofSeconds(10L));
                return WatsonxChatModel.this.client.tokenization(request, token, WatsonxChatModel.this.version).result().tokenCount();
            }
        });
    }
}

