/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.watsonx.bean.TextGenerationRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TextGenerationResponse;
import io.quarkiverse.langchain4j.watsonx.bean.TokenizationRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TokenizationResponse;
import io.quarkiverse.langchain4j.watsonx.bean.WatsonError;
import io.quarkiverse.langchain4j.watsonx.exception.WatsonxException;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.quarkus.rest.client.reactive.NotBody;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestStreamElementType;
import org.jboss.resteasy.reactive.client.api.ClientLogger;

@Path(value="/ml/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ClientHeaderParam(name="Authorization", value={"Bearer {token}"})
public interface WatsonxRestApi {
    @POST
    @Path(value="text/generation")
    public TextGenerationResponse chat(TextGenerationRequest var1, @NotBody String var2, @QueryParam(value="version") String var3) throws WatsonxException;

    @POST
    @Path(value="text/generation_stream")
    @RestStreamElementType(value="text/plain")
    public Multi<String> chatStreaming(TextGenerationRequest var1, @NotBody String var2, @QueryParam(value="version") String var3);

    @POST
    @Path(value="text/tokenization")
    public TokenizationResponse tokenization(TokenizationRequest var1, @NotBody String var2, @QueryParam(value="version") String var3);

    @ClientExceptionMapper
    public static WatsonxException toException(Response response) {
        MediaType mediaType = response.getMediaType();
        if (mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            try {
                WatsonError ex = (WatsonError)response.readEntity(WatsonError.class);
                StringJoiner joiner = new StringJoiner("\n");
                if (ex.errors() != null && ex.errors().size() > 0) {
                    for (WatsonError.Error error : ex.errors()) {
                        joiner.add("%s: %s".formatted(new Object[]{error.code(), error.message()}));
                    }
                }
                return new WatsonxException(joiner.toString(), response.getStatus(), ex);
            }
            catch (Exception e) {
                return new WatsonxException((String)response.readEntity(String.class), (Integer)response.getStatus());
            }
        }
        return new WatsonxException((String)response.readEntity(String.class), (Integer)response.getStatus());
    }

    @ClientObjectMapper
    public static ObjectMapper objectMapper(ObjectMapper defaultObjectMapper) {
        return QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
    }

    public static class WatsonClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(WatsonClientLogger.class);
        private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*)(\\w{4})(\\w+)(\\w{4})");
        private final boolean logRequests;
        private final boolean logResponses;

        public WatsonClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.inOneLine(response.headers()), (Object)this.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if ("Authorization".equals(headerKey)) {
                    headerValue = WatsonClientLogger.maskAuthorizationHeaderValue(headerValue);
                } else if ("api-key".equals(headerKey)) {
                    headerValue = WatsonClientLogger.maskApiKeyHeaderValue(headerValue);
                }
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
            try {
                Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
                StringBuilder sb = new StringBuilder();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
                }
                return sb.toString();
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }

        private static String maskApiKeyHeaderValue(String apiKeyHeaderValue) {
            try {
                if (apiKeyHeaderValue.length() <= 4) {
                    return apiKeyHeaderValue;
                }
                return apiKeyHeaderValue.substring(0, 2) + "..." + apiKeyHeaderValue.substring(apiKeyHeaderValue.length() - 2);
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }
}

