/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.runtime;

import com.google.auth.oauth2.GoogleCredentials;
import io.quarkiverse.langchain4j.vertexai.runtime.PredictRequest;
import io.quarkiverse.langchain4j.vertexai.runtime.PredictResponse;
import io.quarkus.arc.DefaultBean;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestPath;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

@Path(value="v1/projects/{projectId}/locations/{location}/publishers/{publisher}/models")
@RegisterProvider(value=TokenFilter.class)
public interface VertxAiRestApi {
    @Path(value="{modelId}:predict")
    @POST
    public PredictResponse predict(PredictRequest var1, @BeanParam ApiMetadata var2);

    public static class VertxAiClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(VertxAiClientLogger.class);
        private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*)(\\w{2})(\\w|\\.|-|_)+(\\w{2})");
        private final boolean logRequests;
        private final boolean logResponses;

        public VertxAiClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.inOneLine(response.headers()), (Object)this.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if (headerKey.equals("Authorization")) {
                    headerValue = VertxAiClientLogger.maskAuthorizationHeaderValue(headerValue);
                }
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
            try {
                Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
                StringBuilder sb = new StringBuilder();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }

    public static class TokenFilter
    implements ResteasyReactiveClientRequestFilter {
        private final ExecutorService executorService;
        private final AuthProvider authProvider;

        public TokenFilter(ExecutorService executorService, AuthProvider authProvider) {
            this.executorService = executorService;
            this.authProvider = authProvider;
        }

        public void filter(final ResteasyReactiveClientRequestContext context) {
            context.suspend();
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        context.getHeaders().add((Object)"Authorization", (Object)("Bearer " + authProvider.getBearerToken()));
                        context.resume();
                    }
                    catch (Exception e) {
                        context.resume((Throwable)e);
                    }
                }
            });
        }
    }

    @ApplicationScoped
    @DefaultBean
    public static class ApplicationDefaultAuthProvider
    implements AuthProvider {
        @Override
        public String getBearerToken() {
            try {
                GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
                credentials.refreshIfExpired();
                return credentials.getAccessToken().getTokenValue();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static interface AuthProvider {
        public String getBearerToken();
    }

    public static class ApiMetadata {
        @RestPath
        public final String projectId;
        @RestPath
        public final String location;
        @RestPath
        public final String modelId;
        @RestPath
        public final String publisher;

        private ApiMetadata(Builder builder) {
            this.projectId = builder.projectId;
            this.location = builder.location;
            this.modelId = builder.modelId;
            this.publisher = builder.publisher;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String projectId;
            private String location;
            private String modelId;
            private String publisher;

            public Builder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder publisher(String publisherId) {
                this.publisher = publisherId;
                return this;
            }

            public ApiMetadata build() {
                return new ApiMetadata(this);
            }
        }
    }
}

