/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.vertexai.runtime.VertexAiChatLanguageModel;
import io.quarkiverse.langchain4j.vertexai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.vertexai.runtime.config.LangChain4jVertexAiConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class VertexAiRecorder {
    private static final String DUMMY_KEY = "dummy";

    public Supplier<ChatLanguageModel> chatModel(LangChain4jVertexAiConfig config, String configName) {
        LangChain4jVertexAiConfig.VertexAiConfig vertexAiConfig = this.correspondingVertexAiConfig(config, configName);
        if (vertexAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = vertexAiConfig.chatModel();
            Optional<String> baseUrl = vertexAiConfig.baseUrl();
            String location = vertexAiConfig.location();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(location)) {
                throw new ConfigValidationException(VertexAiRecorder.createConfigProblems("location", configName));
            }
            String projectId = vertexAiConfig.projectId();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(projectId)) {
                throw new ConfigValidationException(VertexAiRecorder.createConfigProblems("project-id", configName));
            }
            final VertexAiChatLanguageModel.Builder builder = VertexAiChatLanguageModel.builder().baseUrl(baseUrl).location(location).projectId(projectId).publisher(vertexAiConfig.publisher()).modelId(chatModelConfig.modelId()).maxOutputTokens(chatModelConfig.maxOutputTokens()).temperature(chatModelConfig.temperature()).topK(chatModelConfig.topK()).topP(chatModelConfig.topP()).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false));
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    private LangChain4jVertexAiConfig.VertexAiConfig correspondingVertexAiConfig(LangChain4jVertexAiConfig runtimeConfig, String configName) {
        return NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
    }

    private static ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{VertexAiRecorder.createConfigProblem(key, configName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem("SRCFG00014: The config property quarkus.langchain4j.vertexai%s%s is required but it could not be found in any config source".formatted(NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

