/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.runtime;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.vertexai.runtime.Parameters;
import io.quarkiverse.langchain4j.vertexai.runtime.PredictRequest;
import io.quarkiverse.langchain4j.vertexai.runtime.PredictResponse;
import io.quarkiverse.langchain4j.vertexai.runtime.VertxAiRestApi;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class VertexAiChatLanguageModel
implements ChatLanguageModel {
    private final Parameters parameters;
    private final VertxAiRestApi.ApiMetadata apiMetadata;
    private final VertxAiRestApi restApi;

    private VertexAiChatLanguageModel(Builder builder) {
        this.parameters = Parameters.builder().maxOutputTokens(builder.maxOutputTokens).temperature(builder.temperature).topK(builder.topK).topP(builder.topP).build();
        this.apiMetadata = VertxAiRestApi.ApiMetadata.builder().modelId(builder.modelId).location(builder.location).projectId(builder.projectId).publisher(builder.publisher).build();
        try {
            String baseUrl = builder.baseUrl.orElse(String.format("https://%s-aiplatform.googleapis.com", builder.location));
            QuarkusRestClientBuilder restApiBuilder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrl)).connectTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS);
            if (builder.logRequests.booleanValue() || builder.logResponses.booleanValue()) {
                restApiBuilder.loggingScope(LoggingScope.REQUEST_RESPONSE);
                restApiBuilder.clientLogger((ClientLogger)new VertxAiRestApi.VertxAiClientLogger(builder.logRequests, builder.logResponses));
            }
            this.restApi = (VertxAiRestApi)restApiBuilder.build(VertxAiRestApi.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        PredictRequest predictRequest = new PredictRequest(Collections.singletonList(new PredictRequest.ChatInstance(VertexAiChatLanguageModel.toContext(messages), this.toVertexMessages(messages))), this.parameters);
        PredictResponse predictResponse = this.restApi.predict(predictRequest, this.apiMetadata);
        return Response.from((Object)AiMessage.from((String)predictResponse.predictions().get(0).candidates().get(0).content()), (TokenUsage)new TokenUsage(predictResponse.metadata().tokenMetadata().inputTokenCount().totalTokens(), predictResponse.metadata().tokenMetadata().outputTokenCount().totalTokens()));
    }

    private static String toContext(List<ChatMessage> messages) {
        return messages.stream().filter(chatMessage -> chatMessage.type() == ChatMessageType.SYSTEM).map(ChatMessage::text).collect(Collectors.joining("\n"));
    }

    private List<PredictRequest.Message> toVertexMessages(List<ChatMessage> messages) {
        return messages.stream().filter(chatMessage -> chatMessage.type() == ChatMessageType.USER || chatMessage.type() == ChatMessageType.AI).map(chatMessage -> new PredictRequest.Message(chatMessage.type().name(), chatMessage.text())).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> baseUrl = Optional.empty();
        private String projectId;
        private String location;
        private String modelId;
        private String publisher;
        private Double temperature;
        private Integer maxOutputTokens;
        private Integer topK;
        private Double topP;
        private Duration timeout = Duration.ofSeconds(10L);
        private Boolean logRequests = false;
        private Boolean logResponses = false;

        public Builder baseUrl(Optional<String> baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public VertexAiChatLanguageModel build() {
            return new VertexAiChatLanguageModel(this);
        }
    }
}

