/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.runtime.gemini;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auth.oauth2.GoogleCredentials;
import io.quarkiverse.langchain4j.runtime.auth.ModelAuthProvider;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.GenerateContentRequest;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.GenerateContentResponse;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.config.ChatModelConfig;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestPath;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

@Path(value="v1/projects/{projectId}/locations/{location}/publishers/{publisher}/models")
@RegisterProvider(value=TokenFilter.class)
public interface VertxAiGeminiRestApi {
    @Path(value="{modelId}:generateContent")
    @POST
    public GenerateContentResponse generateContent(GenerateContentRequest var1, @BeanParam ApiMetadata var2);

    @ClientObjectMapper
    public static ObjectMapper mapper(ObjectMapper defaultObjectMapper) {
        return defaultObjectMapper.copy().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class VertxAiClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(VertxAiClientLogger.class);
        private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*)(\\w{2})(\\w|\\.|-|_)+(\\w{2})");
        private final boolean logRequests;
        private final boolean logResponses;

        public VertxAiClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.inOneLine(response.headers()), (Object)this.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if (headerKey.equals("Authorization")) {
                    headerValue = VertxAiClientLogger.maskAuthorizationHeaderValue(headerValue);
                }
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
            try {
                Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
                StringBuilder sb = new StringBuilder();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }

    public static class TokenFilter
    implements ResteasyReactiveClientRequestFilter {
        private final ExecutorService executorService;
        private final ModelAuthProvider defaultAuthorizer;
        private final ModelAuthProvider authorizer;
        @Inject
        Instance<ChatModelConfig> model;

        public TokenFilter(ManagedExecutor executorService) {
            this.executorService = executorService;
            this.defaultAuthorizer = new ApplicationDefaultAuthProvider();
            this.authorizer = ModelAuthProvider.resolve(this.model != null && this.model.isResolvable() ? ((ChatModelConfig)this.model.get()).modelId() : null).orElse(null);
        }

        public void filter(final ResteasyReactiveClientRequestContext context) {
            context.suspend();
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String authorization;
                        AuthInputImpl authInput = new AuthInputImpl(context.getMethod(), context.getUri(), (MultivaluedMap<String, Object>)context.getHeaders());
                        String string = authorization = authorizer != null ? authorizer.getAuthorization((ModelAuthProvider.Input)authInput) : null;
                        if (authorization == null) {
                            authorization = defaultAuthorizer.getAuthorization((ModelAuthProvider.Input)authInput);
                        }
                        context.getHeaders().add((Object)"Authorization", (Object)authorization);
                        context.resume();
                    }
                    catch (Exception e) {
                        context.resume((Throwable)e);
                    }
                }
            });
        }

        private static final class AuthInputImpl
        extends Record
        implements ModelAuthProvider.Input {
            private final String method;
            private final URI uri;
            private final MultivaluedMap<String, Object> headers;

            private AuthInputImpl(String method, URI uri, MultivaluedMap<String, Object> headers) {
                this.method = method;
                this.uri = uri;
                this.headers = headers;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this, o);
            }

            public String method() {
                return this.method;
            }

            public URI uri() {
                return this.uri;
            }

            public MultivaluedMap<String, Object> headers() {
                return this.headers;
            }
        }
    }

    public static class ApplicationDefaultAuthProvider
    implements ModelAuthProvider {
        public String getAuthorization(ModelAuthProvider.Input input) {
            try {
                GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
                credentials.refreshIfExpired();
                return credentials.getAccessToken().getTokenValue();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class ApiMetadata {
        @RestPath
        public final String projectId;
        @RestPath
        public final String location;
        @RestPath
        public final String modelId;
        @RestPath
        public final String publisher;

        private ApiMetadata(Builder builder) {
            this.projectId = builder.projectId;
            this.location = builder.location;
            this.modelId = builder.modelId;
            this.publisher = builder.publisher;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String projectId;
            private String location;
            private String modelId;
            private String publisher;

            public Builder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder publisher(String publisherId) {
                this.publisher = publisherId;
                return this;
            }

            public ApiMetadata build() {
                return new ApiMetadata(this);
            }
        }
    }
}

