/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.runtime.gemini;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.VertexAiGeminiChatLanguageModel;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.config.ChatModelConfig;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.config.LangChain4jVertexAiGeminiConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class VertexAiGeminiRecorder {
    private static final String DUMMY_KEY = "dummy";

    public Supplier<ChatLanguageModel> chatModel(LangChain4jVertexAiGeminiConfig config, String configName) {
        LangChain4jVertexAiGeminiConfig.VertexAiGeminiConfig vertexAiConfig = this.correspondingVertexAiConfig(config, configName);
        if (vertexAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = vertexAiConfig.chatModel();
            Optional<String> baseUrl = vertexAiConfig.baseUrl();
            String location = vertexAiConfig.location();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(location)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("location", configName));
            }
            String projectId = vertexAiConfig.projectId();
            if (baseUrl.isEmpty() && DUMMY_KEY.equals(projectId)) {
                throw new ConfigValidationException(VertexAiGeminiRecorder.createConfigProblems("project-id", configName));
            }
            final VertexAiGeminiChatLanguageModel.Builder builder = VertexAiGeminiChatLanguageModel.builder().baseUrl(baseUrl).location(location).projectId(projectId).publisher(vertexAiConfig.publisher()).modelId(chatModelConfig.modelId()).maxOutputTokens(chatModelConfig.maxOutputTokens()).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false));
            if (chatModelConfig.temperature().isEmpty()) {
                builder.temperature(chatModelConfig.temperature().getAsDouble());
            }
            if (chatModelConfig.topK().isPresent()) {
                builder.topK(chatModelConfig.topK().getAsInt());
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(chatModelConfig.topP().getAsDouble());
            }
            if (chatModelConfig.timeout().isPresent()) {
                builder.timeout(chatModelConfig.timeout().get());
            }
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    private LangChain4jVertexAiGeminiConfig.VertexAiGeminiConfig correspondingVertexAiConfig(LangChain4jVertexAiGeminiConfig runtimeConfig, String configName) {
        return NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
    }

    private static ConfigValidationException.Problem[] createConfigProblems(String key, String configName) {
        return new ConfigValidationException.Problem[]{VertexAiGeminiRecorder.createConfigProblem(key, configName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem("SRCFG00014: The config property quarkus.langchain4j.vertexai.gemini%s%s is required but it could not be found in any config source".formatted(NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

