/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.runtime.gemini;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.GenerateContentRequest;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.GenerationConfig;
import io.quarkiverse.langchain4j.vertexai.runtime.gemini.RoleMapper;
import java.util.ArrayList;
import java.util.List;

final class ContentMapper {
    private ContentMapper() {
    }

    static GenerateContentRequest map(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, GenerationConfig generationConfig) {
        ArrayList<GenerateContentRequest.Tool> tools;
        ArrayList<String> systemPrompts = new ArrayList<String>();
        ArrayList<GenerateContentRequest.Content> contents = new ArrayList<GenerateContentRequest.Content>(messages.size());
        for (ChatMessage message : messages) {
            if (message instanceof SystemMessage) {
                SystemMessage sm = (SystemMessage)message;
                systemPrompts.add(sm.text());
                continue;
            }
            String role = RoleMapper.map(message.type());
            if (message instanceof UserMessage) {
                UserMessage um = (UserMessage)message;
                ArrayList<GenerateContentRequest.Content.Part> parts = new ArrayList<GenerateContentRequest.Content.Part>(um.contents().size());
                for (Content userMessageContent : um.contents()) {
                    if (userMessageContent instanceof TextContent) {
                        TextContent tc = (TextContent)userMessageContent;
                        parts.add(GenerateContentRequest.Content.Part.ofText(tc.text()));
                        continue;
                    }
                    throw new IllegalArgumentException("The Gemini integration currently only supports text content");
                }
                contents.add(new GenerateContentRequest.Content(role, parts));
                continue;
            }
            if (message instanceof AiMessage) {
                AiMessage am = (AiMessage)message;
                if (am.hasToolExecutionRequests()) {
                    throw new IllegalArgumentException("The Gemini integration currently does not support tools");
                }
                contents.add(new GenerateContentRequest.Content(role, List.of(GenerateContentRequest.Content.Part.ofText(am.text()))));
                continue;
            }
            throw new IllegalArgumentException("The Gemini integration currently does not support " + message.type() + " messages");
        }
        if (toolSpecifications == null || toolSpecifications.isEmpty()) {
            tools = null;
        } else {
            tools = new ArrayList<GenerateContentRequest.Tool>(toolSpecifications.size());
            for (GenerateContentRequest.Tool tool : tools) {
            }
        }
        return new GenerateContentRequest(contents, !systemPrompts.isEmpty() ? GenerateContentRequest.SystemInstruction.ofContent(systemPrompts) : null, tools, generationConfig);
    }
}

