/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.vertexai.deployment;

import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.vertexai.deployment.LangChain4jVertexAiBuildConfig;
import io.quarkiverse.langchain4j.vertexai.runtime.VertexAiRecorder;
import io.quarkiverse.langchain4j.vertexai.runtime.config.LangChain4jVertexAiConfig;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class VertexAiProcessor {
    private static final String FEATURE = "langchain4j-vertexai";
    private static final String PROVIDER = "vertexai";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, LangChain4jVertexAiBuildConfig config) {
        if (config.chatModel().enabled().isEmpty()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(VertexAiRecorder recorder, List<SelectedChatModelProviderBuildItem> selectedChatItem, LangChain4jVertexAiConfig config, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        for (SelectedChatModelProviderBuildItem selected : selectedChatItem) {
            if (!PROVIDER.equals(selected.getProvider())) continue;
            String configName = selected.getConfigName();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.chatModel(config, configName));
            this.addQualifierIfNecessary(builder, configName);
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String configName) {
        if (!NamedConfigUtil.isDefault((String)configName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", configName).build());
        }
    }
}

