/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.testing.internal;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.ConfigProvider;

public abstract class WiremockAware {
    private WireMock wireMock;

    public static String wiremockUrlForConfig() {
        return "http://localhost:${quarkus.wiremock.devservices.port}";
    }

    public static String wiremockUrlForConfig(String path) {
        if (((String)path).isEmpty()) {
            return WiremockAware.wiremockUrlForConfig();
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return WiremockAware.wiremockUrlForConfig() + (String)path;
    }

    public String resolvedWiremockUrl() {
        return String.format("http://localhost:%d", this.getResolvedWiremockPort());
    }

    public String resolvedWiremockUrl(String path) {
        if (((String)path).isEmpty()) {
            return this.resolvedWiremockUrl();
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return this.resolvedWiremockUrl() + (String)path;
    }

    protected WireMock wiremock() {
        if (this.wireMock == null) {
            this.wireMock = new WireMock(this.getResolvedWiremockPort().intValue());
        }
        return this.wireMock;
    }

    private Integer getResolvedWiremockPort() {
        return (Integer)ConfigProvider.getConfig().getValue("quarkus.wiremock.devservices.port", Integer.class);
    }

    protected void resetRequests() {
        this.wiremock().resetRequests();
    }

    protected void resetMappings() {
        this.wiremock().resetMappings();
    }

    protected LoggedRequest singleLoggedRequest() {
        Assertions.assertThat((List)this.wiremock().getServeEvents()).hasSize(1);
        ServeEvent serveEvent = (ServeEvent)this.wiremock().getServeEvents().get(0);
        return serveEvent.getRequest();
    }

    protected byte[] requestBodyOfSingleRequest() {
        return this.singleLoggedRequest().getBody();
    }

    protected byte[] getRequestBody(ServeEvent serveEvent) {
        LoggedRequest request = serveEvent.getRequest();
        Assertions.assertThat((byte[])request.getBody()).isNotEmpty();
        return request.getBody();
    }
}

