/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.redis.runtime;

import io.quarkiverse.langchain4j.redis.RedisEmbeddingStore;
import io.quarkiverse.langchain4j.redis.runtime.RedisEmbeddingStoreConfig;
import io.quarkiverse.langchain4j.redis.runtime.RedisSchema;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.redis.client.RedisClientName;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.function.Function;

@Recorder
public class RedisEmbeddingStoreRecorder {
    public Function<SyntheticCreationalContext<RedisEmbeddingStore>, RedisEmbeddingStore> embeddingStoreFunction(final RedisEmbeddingStoreConfig config, final String clientName) {
        return new Function<SyntheticCreationalContext<RedisEmbeddingStore>, RedisEmbeddingStore>(){

            @Override
            public RedisEmbeddingStore apply(SyntheticCreationalContext<RedisEmbeddingStore> context) {
                RedisEmbeddingStore.Builder builder = new RedisEmbeddingStore.Builder();
                ReactiveRedisDataSource dataSource = clientName == null ? (ReactiveRedisDataSource)context.getInjectedReference(ReactiveRedisDataSource.class, new Annotation[]{new Default.Literal()}) : (ReactiveRedisDataSource)context.getInjectedReference(ReactiveRedisDataSource.class, new Annotation[]{new RedisClientName.Literal(clientName)});
                builder.dataSource(dataSource);
                RedisSchema schema = new RedisSchema.Builder().indexName(config.indexName()).prefix(config.prefix()).vectorFieldName(config.vectorFieldName()).scalarFieldName(config.scalarFieldName()).metadataFields(config.metadataFields().orElse(Collections.emptyList())).vectorAlgorithm(config.vectorAlgorithm()).dimension(config.dimension()).metricType(config.distanceMetric()).build();
                builder.schema(schema);
                return builder.build();
            }
        };
    }
}

