/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.qdrant;

import io.qdrant.client.QdrantClient;
import io.qdrant.client.QdrantGrpcClient;
import io.qdrant.client.grpc.Collections;
import io.quarkiverse.langchain4j.qdrant.QdrantBuildConfig;
import io.quarkiverse.langchain4j.qdrant.QdrantContainer;
import io.quarkiverse.langchain4j.qdrant.QdrantDevServiceCfg;
import io.quarkiverse.langchain4j.qdrant.QdrantDevServices;
import io.quarkiverse.langchain4j.qdrant.QdrantVectorCfg;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class QdrantDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(QdrantDevServicesProcessor.class);
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile QdrantDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public List<DevServicesResultBuildItem> startQdrantDevServices(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, QdrantBuildConfig qdrantBuildConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        ArrayList<DevServicesResultBuildItem> result = new ArrayList<DevServicesResultBuildItem>();
        QdrantDevServiceCfg configuration = this.getConfiguration(qdrantBuildConfig);
        if (devService != null) {
            boolean shouldShutdown;
            boolean bl = shouldShutdown = !configuration.equals(cfg);
            if (!shouldShutdown) {
                result.add(devService.toBuildItem());
                return result;
            }
            this.shutdownContainers();
            cfg = null;
        }
        if (!qdrantBuildConfig.devservices().enabled()) {
            LOG.debug((Object)"Not starting Dev Services for Qdrant, as it has been disabled in the config.");
            return Collections.emptyList();
        }
        if (ConfigUtils.isPropertyPresent((String)"quarkus.langchain4j.qdrant.host")) {
            return Collections.emptyList();
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Qdrant Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService newDevService = this.startQdrantContainer(dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout, !devServicesSharedNetworkBuildItem.isEmpty());
            if (newDevService != null && (devService = newDevService).isOwner()) {
                LOG.infof("Dev Services instance of Qdrant started (config: %s)", (Object)newDevService.getConfig());
            }
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return Collections.emptyList();
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                this.shutdownContainers();
                first = true;
                cfg = null;
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        cfg = configuration;
        result.add(devService.toBuildItem());
        return result;
    }

    private void shutdownContainers() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                LOG.error((Object)"Failed to stop the Qdrant server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startQdrantContainer(DockerStatusBuildItem dockerStatusBuildItem, QdrantDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout, boolean useSharedNetwork) {
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            LOG.warn((Object)"Docker isn't working, please configure the Qdrant server location.");
            return null;
        }
        QdrantContainer container = new QdrantContainer(config.imageName(), config.fixedPort(), launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName() : null, useSharedNetwork);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultQdrantSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((QdrantContainer)container).withStartupTimeout(arg_0));
            container.start();
            if (config.vectorCfg() != null) {
                try (QdrantClient client = this.client(container);){
                    client.createCollectionAsync(config.serviceName(), Collections.VectorParams.newBuilder().setDistance(config.vectorCfg().distance()).setSize(config.vectorCfg().size()).build()).get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.getRunningQdrantDevService(config.serviceName(), container.getContainerId(), () -> ((QdrantContainer)container).close(), container.getHost(), container.getPort());
        };
        return QdrantDevServices.LOCATOR.locateContainer(config.serviceName(), config.shared(), launchMode.getLaunchMode()).map(containerAddress -> this.getRunningQdrantDevService(config.serviceName(), containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort())).orElseGet(defaultQdrantSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningQdrantDevService(String serviceName, String containerId, Closeable closeable, String host, int port) {
        Map<String, String> configMap = Map.of("quarkus.langchain4j.qdrant.collection.name", serviceName, "quarkus.langchain4j.qdrant.host", host, "quarkus.langchain4j.qdrant.port", String.valueOf(port));
        return new DevServicesResultBuildItem.RunningDevService("langchain4j-qdrant", containerId, closeable, configMap);
    }

    private QdrantDevServiceCfg getConfiguration(QdrantBuildConfig cfg) {
        return new QdrantDevServiceCfg(cfg.devservices().enabled(), cfg.devservices().port(), cfg.devservices().qdrantImageName(), cfg.devservices().serviceName(), cfg.devservices().shared(), cfg.devservices().collection().map(c -> {
            Collections.Distance distance = Collections.Distance.valueOf((String)c.vectorParams().distance().name());
            return new QdrantVectorCfg(distance, c.vectorParams().size());
        }).orElse(null));
    }

    private QdrantClient client(QdrantContainer container) {
        return new QdrantClient(QdrantGrpcClient.newBuilder((String)container.getHost(), (int)container.getPort(), (boolean)false).build());
    }

    static {
        first = true;
    }
}

