/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.qdrant;

import io.quarkus.devservices.common.ConfigureUtil;
import java.util.OptionalInt;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class QdrantContainer
extends org.testcontainers.qdrant.QdrantContainer {
    private final OptionalInt fixedExposedPort;
    private final boolean useSharedNetwork;
    private String hostName = null;

    public QdrantContainer(String image, OptionalInt fixedExposedPort, String serviceName, boolean useSharedNetwork) {
        super(DockerImageName.parse((String)image).asCompatibleSubstituteFor("qdrant/qdrant"));
        if (serviceName != null) {
            this.withLabel("quarkus-dev-service-qdrant", serviceName);
        }
        this.fixedExposedPort = fixedExposedPort;
        this.useSharedNetwork = useSharedNetwork;
    }

    protected void configure() {
        super.configure();
        if (this.useSharedNetwork) {
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"qdrant");
            return;
        }
        if (this.fixedExposedPort.isPresent()) {
            this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 6334);
        } else {
            this.addExposedPort(6334);
        }
    }

    public int getPort() {
        if (this.useSharedNetwork) {
            return 6334;
        }
        if (this.fixedExposedPort.isPresent()) {
            return this.fixedExposedPort.getAsInt();
        }
        return super.getMappedPort(6334);
    }

    public String getHost() {
        return this.useSharedNetwork ? this.hostName : super.getHost();
    }
}

