/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.pinecone.runtime;

import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.HashMap;
import java.util.Map;

@RegisterForReflection
public class UpsertVector {
    private final String id;
    private final float[] values;
    private final Map<String, String> metadata;

    public UpsertVector(Builder builder) {
        this.id = builder.id;
        this.values = builder.value;
        this.metadata = builder.metadata;
    }

    public String getId() {
        return this.id;
    }

    public float[] getValues() {
        return this.values;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Builder {
        private String id = null;
        private float[] value = null;
        private Map<String, String> metadata = new HashMap<String, String>();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder value(float[] value) {
            this.value = value;
            return this;
        }

        public Builder metadata(String key, String value) {
            if (key != null && value != null) {
                this.metadata.put(key, value);
            }
            return this;
        }

        public Builder metadata(Map<String, String> map) {
            if (map != null) {
                this.metadata.putAll(map);
            }
            return this;
        }

        public UpsertVector build() {
            return new UpsertVector(this);
        }
    }
}

