/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.pinecone;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.RelevanceScore;
import io.quarkiverse.langchain4j.pinecone.runtime.CreateIndexPodSpec;
import io.quarkiverse.langchain4j.pinecone.runtime.CreateIndexRequest;
import io.quarkiverse.langchain4j.pinecone.runtime.CreateIndexSpec;
import io.quarkiverse.langchain4j.pinecone.runtime.DistanceMetric;
import io.quarkiverse.langchain4j.pinecone.runtime.PineconeIndexOperationsApi;
import io.quarkiverse.langchain4j.pinecone.runtime.PineconeVectorOperationsApi;
import io.quarkiverse.langchain4j.pinecone.runtime.QueryRequest;
import io.quarkiverse.langchain4j.pinecone.runtime.QueryResponse;
import io.quarkiverse.langchain4j.pinecone.runtime.UpsertRequest;
import io.quarkiverse.langchain4j.pinecone.runtime.UpsertResponse;
import io.quarkiverse.langchain4j.pinecone.runtime.UpsertVector;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.logging.Log;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;

public class PineconeEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private final PineconeVectorOperationsApi vectorOperations;
    private final PineconeIndexOperationsApi indexOperations;
    private final String namespace;
    private final String textFieldName;
    private final String indexName;
    private final Integer dimension;
    private final LazyValue<Object> indexExists;

    public PineconeEmbeddingStore(final String apiKey, final String indexName, String projectId, final String environment, String namespace, String textFieldName, Duration timeout, final Integer dimension, final String podType, final Duration indexReadinessTimeout) {
        this.indexName = indexName;
        this.dimension = dimension;
        String baseUrl = "https://" + indexName + "-" + projectId + ".svc." + environment + ".pinecone.io";
        String baseUrlIndexOperations = "https://api.pinecone.io";
        try {
            ClientHeadersFactory clientHeadersFactory = new ClientHeadersFactory(){

                public MultivaluedMap<String, String> update(MultivaluedMap<String, String> incoming, MultivaluedMap<String, String> outgoing) {
                    MultivaluedHashMap headers = new MultivaluedHashMap();
                    headers.put((Object)"Api-Key", Collections.singletonList(apiKey));
                    return headers;
                }
            };
            this.vectorOperations = (PineconeVectorOperationsApi)QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrl)).connectTimeout(timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(timeout.toSeconds(), TimeUnit.SECONDS).clientHeadersFactory(clientHeadersFactory).build(PineconeVectorOperationsApi.class);
            this.indexOperations = (PineconeIndexOperationsApi)QuarkusRestClientBuilder.newBuilder().baseUri(new URI(baseUrlIndexOperations)).connectTimeout(timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(timeout.toSeconds(), TimeUnit.SECONDS).clientHeadersFactory(clientHeadersFactory).build(PineconeIndexOperationsApi.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.namespace = namespace;
        this.textFieldName = textFieldName;
        Log.info((Object)("PineconeEmbeddingStore using base URL: " + baseUrl));
        this.indexExists = new LazyValue((Supplier)new Supplier<Object>(){

            @Override
            public Object get() {
                if (PineconeEmbeddingStore.this.indexOperations.listIndexes().getIndexes().stream().anyMatch(i -> i.getName().equals(indexName))) {
                    Log.info((Object)("Pinecone index " + indexName + " already exists"));
                } else {
                    if (dimension == null) {
                        throw new IllegalArgumentException("quarkus.langchain4j.pinecone.dimension must be specified when creating a new index");
                    }
                    CreateIndexSpec spec = new CreateIndexSpec(new CreateIndexPodSpec(environment, podType));
                    PineconeEmbeddingStore.this.indexOperations.createIndex(new CreateIndexRequest(indexName, dimension, DistanceMetric.COSINE, spec));
                    Log.info((Object)("Created Pinecone index " + indexName + " with dimension = " + dimension + ", now waiting for it to be become ready..."));
                    PineconeEmbeddingStore.this.waitForIndexToBecomeReady(indexName, indexReadinessTimeout);
                }
                return new Object();
            }
        });
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, embedded);
        return ids;
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding embedding, int maxResults, double minScore) {
        this.indexExists.get();
        QueryRequest request = new QueryRequest(this.namespace, Long.valueOf(maxResults), true, true, embedding.vector());
        QueryResponse response = this.vectorOperations.query(request);
        return response.getMatches().stream().map(match -> {
            String text = match.getMetadata() != null && match.getMetadata().get(this.textFieldName) != null ? match.getMetadata().get(this.textFieldName) : null;
            return new EmbeddingMatch(Double.valueOf(RelevanceScore.fromCosineSimilarity((double)match.getScore())), match.getId(), new Embedding(match.getValues()), (Object)(text != null ? new TextSegment(text, new Metadata(this.mapWithoutKey(match.getMetadata(), this.textFieldName))) : null));
        }).filter(match -> match.score() >= minScore).collect(Collectors.toList());
    }

    public PineconeVectorOperationsApi getUnderlyingClient() {
        return this.vectorOperations;
    }

    public Map<String, String> mapWithoutKey(Map<String, String> input, String key) {
        return input.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(key)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void addInternal(String id, Embedding embedding, TextSegment textSegment) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), textSegment == null ? null : Collections.singletonList(textSegment));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> textSegments) {
        this.indexExists.get();
        Log.debug((Object)("Adding embeddings: " + embeddings));
        int count = ids.size();
        ArrayList<UpsertVector> vectorList = new ArrayList<UpsertVector>();
        for (int i = 0; i < count; ++i) {
            UpsertVector vector = new UpsertVector.Builder().id(ids.get(i)).value(embeddings.get(i).vector()).metadata(this.textFieldName, textSegments == null ? null : textSegments.get(i).text()).metadata(textSegments != null ? textSegments.get(i).metadata().asMap() : null).build();
            vectorList.add(vector);
        }
        UpsertRequest request = new UpsertRequest(vectorList, this.namespace);
        UpsertResponse response = this.vectorOperations.upsert(request);
        Log.debug((Object)("Added embeddings: " + response.getUpsertedCount()));
    }

    private void waitForIndexToBecomeReady(String indexName, Duration timeout) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout.toMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!this.indexOperations.describeIndex(indexName).getStatus().isReady()) continue;
            Log.info((Object)("Pinecone index " + indexName + " is now ready"));
            return;
        }
        throw new RuntimeException("Index " + indexName + " did not become ready within " + timeout);
    }
}

