/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openshiftai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import io.quarkiverse.langchain4j.openshiftai.OpenshiftAiChatModel;
import io.quarkiverse.langchain4j.openshiftai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.openshiftai.runtime.config.Langchain4jOpenshiftAiConfig;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Supplier;

@Recorder
public class OpenshiftAiRecorder {
    private static final String DUMMY_URL = "https://dummy.ai/api";
    private static final String DUMMY_MODEL_ID = "dummy";
    public static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];

    public Supplier<ChatLanguageModel> chatModel(Langchain4jOpenshiftAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenshiftAiConfig.OpenshiftAiConfig openshiftAiConfig = this.correspondingOpenshiftAiConfig(runtimeConfig, modelName);
        if (openshiftAiConfig.enableIntegration().booleanValue()) {
            String modelId;
            ChatModelConfig chatModelConfig = openshiftAiConfig.chatModel();
            ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
            URL baseUrl = openshiftAiConfig.baseUrl();
            if (DUMMY_URL.equals(baseUrl.toString())) {
                configProblems.add(this.createBaseURLConfigProblem(modelName));
            }
            if (DUMMY_MODEL_ID.equals(modelId = chatModelConfig.modelId())) {
                configProblems.add(this.createModelIdConfigProblem(modelName));
            }
            if (!configProblems.isEmpty()) {
                throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
            }
            final OpenshiftAiChatModel.Builder builder = OpenshiftAiChatModel.builder().url(baseUrl).timeout(openshiftAiConfig.timeout()).logRequests(openshiftAiConfig.logRequests()).logResponses(openshiftAiConfig.logResponses()).modelId(modelId);
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    private Langchain4jOpenshiftAiConfig.OpenshiftAiConfig correspondingOpenshiftAiConfig(Langchain4jOpenshiftAiConfig runtimeConfig, String modelName) {
        Langchain4jOpenshiftAiConfig.OpenshiftAiConfig openshiftAiConfig = NamedModelUtil.isDefault((String)modelName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(modelName);
        return openshiftAiConfig;
    }

    private ConfigValidationException.Problem createBaseURLConfigProblem(String modelName) {
        return OpenshiftAiRecorder.createConfigProblem("base-url", modelName);
    }

    private ConfigValidationException.Problem createModelIdConfigProblem(String modelName) {
        return OpenshiftAiRecorder.createConfigProblem("chat-model.model-id", modelName);
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String modelName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.openshift-ai%s%s is required but it could not be found in any config source", NamedModelUtil.isDefault((String)modelName) ? "." : "." + modelName + ".", key));
    }
}

