/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openshiftai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import io.quarkiverse.langchain4j.openshiftai.OpenshiftAiChatModel;
import io.quarkiverse.langchain4j.openshiftai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.openshiftai.runtime.config.LangChain4jOpenshiftAiConfig;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Supplier;

@Recorder
public class OpenshiftAiRecorder {
    private static final String DUMMY_URL = "https://dummy.ai/api";
    private static final String DUMMY_MODEL_ID = "dummy";
    public static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];

    public Supplier<ChatLanguageModel> chatModel(LangChain4jOpenshiftAiConfig runtimeConfig, String configName) {
        LangChain4jOpenshiftAiConfig.OpenshiftAiConfig openshiftAiConfig = this.correspondingOpenshiftAiConfig(runtimeConfig, configName);
        if (openshiftAiConfig.enableIntegration().booleanValue()) {
            String modelId;
            ChatModelConfig chatModelConfig = openshiftAiConfig.chatModel();
            ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
            URL baseUrl = openshiftAiConfig.baseUrl();
            if (DUMMY_URL.equals(baseUrl.toString())) {
                configProblems.add(this.createBaseURLConfigProblem(configName));
            }
            if (DUMMY_MODEL_ID.equals(modelId = chatModelConfig.modelId())) {
                configProblems.add(this.createModelIdConfigProblem(configName));
            }
            if (!configProblems.isEmpty()) {
                throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
            }
            final OpenshiftAiChatModel.Builder builder = OpenshiftAiChatModel.builder().url(baseUrl).timeout(openshiftAiConfig.timeout().orElse(Duration.ofSeconds(10L))).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false)).modelId(modelId);
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    private LangChain4jOpenshiftAiConfig.OpenshiftAiConfig correspondingOpenshiftAiConfig(LangChain4jOpenshiftAiConfig runtimeConfig, String configName) {
        LangChain4jOpenshiftAiConfig.OpenshiftAiConfig openshiftAiConfig = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return openshiftAiConfig;
    }

    private ConfigValidationException.Problem createBaseURLConfigProblem(String configName) {
        return OpenshiftAiRecorder.createConfigProblem("base-url", configName);
    }

    private ConfigValidationException.Problem createModelIdConfigProblem(String configName) {
        return OpenshiftAiRecorder.createConfigProblem("chat-model.model-id", configName);
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.openshift-ai%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

