/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime.devui;

import dev.langchain4j.data.image.Image;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiImageModel;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class OpenAiImagesJsonRPCService {
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.base-url")
    String baseUrl;
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.api-key")
    String apiKey;
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.timeout")
    Duration timeout;
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.image-model.user")
    Optional<String> user;
    @Inject
    @ConfigProperty(name="quarkus.langchain4j.openai.max-retries")
    Integer maxRetries;

    public JsonObject generate(String modelName, String size, String prompt, String quality) {
        QuarkusOpenAiImageModel model = QuarkusOpenAiImageModel.builder().baseUrl(this.baseUrl).apiKey(this.apiKey).timeout(this.timeout).user(this.user).maxRetries(this.maxRetries).persistDirectory(Optional.empty()).modelName(modelName).quality(quality).size(size).build();
        Image image = (Image)model.generate(prompt).content();
        JsonObject result = new JsonObject();
        result.put("prompt", (Object)prompt);
        if (image.url() != null) {
            result.put("url", (Object)image.url().toString());
        } else {
            result.put("url", null);
        }
        if (image.base64Data() != null && !image.base64Data().isEmpty()) {
            result.put("base64Data", (Object)image.base64Data());
        } else {
            result.put("base64Data", null);
        }
        return result;
    }
}

