/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime;

import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiModerationModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiClient;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiImageModel;
import io.quarkiverse.langchain4j.openai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ImageModelConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.Langchain4jOpenAiConfig;
import io.quarkiverse.langchain4j.openai.runtime.config.ModerationModelConfig;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class OpenAiRecorder {
    public Supplier<?> chatModel(Langchain4jOpenAiConfig runtimeConfig) {
        Optional<String> apiKeyOpt = runtimeConfig.apiKey();
        if (apiKeyOpt.isEmpty()) {
            throw new ConfigValidationException(this.createApiKeyConfigProblems());
        }
        ChatModelConfig chatModelConfig = runtimeConfig.chatModel();
        final OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder().baseUrl(runtimeConfig.baseUrl()).apiKey(apiKeyOpt.get()).timeout(runtimeConfig.timeout()).maxRetries(runtimeConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), runtimeConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), runtimeConfig.logResponses()})).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty());
        runtimeConfig.organizationId().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)builder).organizationId(arg_0));
        if (chatModelConfig.maxTokens().isPresent()) {
            builder.maxTokens(chatModelConfig.maxTokens().get());
        }
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return builder.build();
            }
        };
    }

    public Supplier<?> streamingChatModel(Langchain4jOpenAiConfig runtimeConfig) {
        Optional<String> apiKeyOpt = runtimeConfig.apiKey();
        if (apiKeyOpt.isEmpty()) {
            throw new ConfigValidationException(this.createApiKeyConfigProblems());
        }
        ChatModelConfig chatModelConfig = runtimeConfig.chatModel();
        final OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder builder = OpenAiStreamingChatModel.builder().baseUrl(runtimeConfig.baseUrl()).apiKey(apiKeyOpt.get()).timeout(runtimeConfig.timeout()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), runtimeConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), runtimeConfig.logResponses()})).modelName(chatModelConfig.modelName()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty());
        runtimeConfig.organizationId().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).organizationId(arg_0));
        if (chatModelConfig.maxTokens().isPresent()) {
            builder.maxTokens(chatModelConfig.maxTokens().get());
        }
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return builder.build();
            }
        };
    }

    public Supplier<?> embeddingModel(Langchain4jOpenAiConfig runtimeConfig) {
        Optional<String> apiKeyOpt = runtimeConfig.apiKey();
        if (apiKeyOpt.isEmpty()) {
            throw new ConfigValidationException(this.createApiKeyConfigProblems());
        }
        EmbeddingModelConfig embeddingModelConfig = runtimeConfig.embeddingModel();
        final OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder builder = OpenAiEmbeddingModel.builder().baseUrl(runtimeConfig.baseUrl()).apiKey(apiKeyOpt.get()).timeout(runtimeConfig.timeout()).maxRetries(runtimeConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), runtimeConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), runtimeConfig.logResponses()})).modelName(embeddingModelConfig.modelName());
        runtimeConfig.organizationId().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).organizationId(arg_0));
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return builder.build();
            }
        };
    }

    public Supplier<?> moderationModel(Langchain4jOpenAiConfig runtimeConfig) {
        Optional<String> apiKeyOpt = runtimeConfig.apiKey();
        if (apiKeyOpt.isEmpty()) {
            throw new ConfigValidationException(this.createApiKeyConfigProblems());
        }
        ModerationModelConfig moderationModelConfig = runtimeConfig.moderationModel();
        final OpenAiModerationModel.OpenAiModerationModelBuilder builder = OpenAiModerationModel.builder().baseUrl(runtimeConfig.baseUrl()).apiKey(apiKeyOpt.get()).timeout(runtimeConfig.timeout()).maxRetries(runtimeConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logRequests(), runtimeConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{moderationModelConfig.logResponses(), runtimeConfig.logResponses()})).modelName(moderationModelConfig.modelName());
        runtimeConfig.organizationId().ifPresent(arg_0 -> ((OpenAiModerationModel.OpenAiModerationModelBuilder)builder).organizationId(arg_0));
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return builder.build();
            }
        };
    }

    public Supplier<?> imageModel(Langchain4jOpenAiConfig runtimeConfig) {
        Optional<String> apiKeyOpt = runtimeConfig.apiKey();
        if (apiKeyOpt.isEmpty()) {
            throw new ConfigValidationException(this.createApiKeyConfigProblems());
        }
        ImageModelConfig imageModelConfig = runtimeConfig.imageModel();
        final QuarkusOpenAiImageModel.Builder builder = QuarkusOpenAiImageModel.builder().baseUrl(runtimeConfig.baseUrl()).apiKey(apiKeyOpt.get()).timeout(runtimeConfig.timeout()).maxRetries(runtimeConfig.maxRetries()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logRequests(), runtimeConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{imageModelConfig.logResponses(), runtimeConfig.logResponses()})).modelName(imageModelConfig.modelName()).size(imageModelConfig.size()).quality(imageModelConfig.quality()).style(imageModelConfig.style()).responseFormat(imageModelConfig.responseFormat()).user(imageModelConfig.user());
        runtimeConfig.organizationId().ifPresent(builder::organizationId);
        Optional<Path> persistDirectory = Optional.empty();
        if (imageModelConfig.persist().isPresent()) {
            if (imageModelConfig.persist().get().booleanValue()) {
                persistDirectory = imageModelConfig.persistDirectory().or((Supplier<Optional<Path>>)new Supplier<Optional<? extends Path>>(){

                    @Override
                    public Optional<? extends Path> get() {
                        return Optional.of(Paths.get(System.getProperty("java.io.tmpdir"), "dall-e-images"));
                    }
                });
            }
        } else if (imageModelConfig.persistDirectory().isPresent()) {
            persistDirectory = imageModelConfig.persistDirectory();
        }
        builder.persistDirectory(persistDirectory);
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return builder.build();
            }
        };
    }

    private ConfigValidationException.Problem[] createApiKeyConfigProblems() {
        return this.createConfigProblems("api-key");
    }

    private ConfigValidationException.Problem[] createConfigProblems(String key) {
        return new ConfigValidationException.Problem[]{this.createConfigProblem(key)};
    }

    private ConfigValidationException.Problem createConfigProblem(String key) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.openai.%s is required but it could not be found in any config source", key));
    }

    public void cleanUp(ShutdownContext shutdown) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusOpenAiClient.clearCache();
            }
        });
    }
}

